<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Validator;

use App\Models\Warehouse;
use App\Models\Transferproduct;
use App\Models\Warehousetransfer;
use App\Models\Product;
use App\Models\warehouseTransferStatusHistory;

class WarehousesController extends Controller
{
    public function add(Request $request){

        $validatedData = Validator($request->all(),[
            'warehouse_name' => 'required',
            'phone_number' => 'required',
            'email' => 'required',
            'address' => 'required',
            // 'stock' => 'required',
            'contact_name' => 'required',
        ]);

        if($validatedData->fails()){
            $msg = $this->validatersErrorString($validatedData->errors());

            return response()->json(['message' => $msg , 'status'=>500],200);
        }

        // 'contact_name'
        // 'latitude'
        // 'longitude'

        $slug = $this->createSlug('warehouses',$request->warehouse_name);

        $userDetails = $this->userDetails($request);

        if($userDetails[0] == 'user'){
            if($userDetails[1]->user_type == 'Staff'){
                $user_id = $userDetails[1]->reporting_id;
            }else{
                $user_id = $userDetails[1]->id;
            }

        }else{
            $user_id = $request->user_id;
        }

        Warehouse::insert([
            'user_id' => $user_id,
            'warehouse_name' => $request->warehouse_name,
            'phone_number' => $request->phone_number,
            'email' => $request->email,
            'address' => $request->address,
            'contact_name' => $request->contact_name,
            // 'stock' => $request->stock,
            'slug' => $slug,
            'status' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        return response()->json(['message' => 'Warehouse created sucessfully' , 'status'=>200],200);
    }

    public function edit(Request $request, $slug = null){

        if($slug == ''){
            return response()->json(['message' => 'invalid request slug was blank' , 'status'=>500 ],200);
        }

        if(!empty($request->all())){

            $validatedData = Validator($request->all(),[
                'warehouse_name' => 'required',
                'phone_number' => 'required',
                'email' => 'required',
                'address' => 'required',
                // 'stock' => 'required',
                'contact_name' => 'required',
            ]);

            if($validatedData->fails()){
                $msg = $this->validatersErrorString($validatedData->errors());

                return response()->json(['message' => $msg , 'status'=>500],200);
            }

            Warehouse::where('slug',$slug)->update([
                'warehouse_name' => $request->warehouse_name,
                'phone_number' => $request->phone_number,
                'email' => $request->email,
                'address' => $request->address,
                // 'stock' => $request->stock,
                'contact_name' => $request->contact_name,
            ]);

            return response()->json(['message' => 'Warehouse updated sucessfully' , 'status'=>200],200);

        }else{
            $warehouse = Warehouse::where('slug',$slug)->first();

            return response()->json(['message' => 'Warehouse data', 'data' => $warehouse , 'status'=>200 ],200);

        }
    }

    public function activate(Request $request, $slug = null){

        if($slug != ''){
            Warehouse::Where('slug',$slug)->update(['status' => 1]);
            return response()->json(['message' => 'Warehouse activated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function deactivate(Request $request, $slug = null){
        if($slug != ''){
            Warehouse::Where('slug',$slug)->update(['status' => 0]);
            return response()->json(['message' => 'Warehouse deactivated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function delete(Request $request, $slug = null){
        if($slug != ''){
            Warehouse::Where('slug',$slug)->delete();
            return response()->json(['message' => 'Warehouse deleted sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function index(Request $request){

        $query = Warehouse::query();

        $userDetails = $this->userDetails($request);

        if($userDetails[0] == 'user'){
            if($userDetails[1]->user_type == 'Staff'){
                $query = $query->where('user_id',$userDetails[1]->reporting_id);
            }else{
                $query = $query->where('user_id',$userDetails[1]->id);
            }

        }

        if(!empty($request->all())){
            $id = $request->idList;
            $action = $request->action;
            if($action != ''){
                if($action ==  'activate'){
                    Warehouse::WhereIn('id',$id)->update(['status' => 1]);
                }else if($action == 'deactivate'){
                    Warehouse::WhereIn('id',$id)->update(['status' => 0]);
                }else if($action == 'delete'){
                    Warehouse::WhereIn('id',$id)->delete();
                }
            }else{
                // if($request->name != ''){
                //     $query = $query->where('warehouse_name' , 'like' , '%'.$request->name.'%');
                // }
            }
        }

        $warehouse = $query->get();

        return response()->json(['message' => 'Warehouse data', 'data' => $warehouse ,'status'=>200],200);

    }

    public function addTransfer(Request $request){
        if(!empty($request->all())){

            $validatedData = Validator($request->all(),[
                'date' => 'required',
                'from_warehouse' => 'required',
                'to_warehouse' => 'required',
                'total' => 'required',
                // 'total_tax' => 'required',
                'finaltotal' => 'required'
            ]);

            if($validatedData->fails()){
                $msg = $this->validatersErrorString($validatedData->errors());

                return response()->json(['message' => $msg , 'status'=>500],200);
            }

            $slug = $this->createSlug('warehousetransfers',time());

            $userDetails = $this->userDetails($request);

            if($userDetails[0] == 'user'){
                if($userDetails[1]->user_type == 'Staff'){
                    $user_id = $userDetails[1]->reporting_id;
                }else{
                    $user_id = $userDetails[1]->id;
                }
            }else{
                $user_id = $request->user_id;
            }

            $transfer_id = Warehousetransfer::insertGetId([
                'user_id' => $user_id,
                'date' => $request->date,
                'from_warehouse' => $request->from_warehouse,
                'to_warehouse' => $request->to_warehouse,
                'shipping_cost' => $request->shipping_cost,
                // 'total_tax' => $request->total_tax,
                'finaltotal' => $request->finaltotal,
                'total' => $request->total,
                'slug' => $slug,
                'status' => 1,
                'transferstatus' => 1,
                'created_at' => now(),
                'updated_at' => now(),

            ]);

            $products = $request->products;

            foreach($products as $product){

                $slug = $this->createSlug('transferproducts',time());

                Transferproduct::insert([
                    'transfer_id' => $transfer_id,
                    'product_id' => $product['id'],
                    'quantity' => $product['quantity'],
                    // 'taxPrice' => $product['taxPrice'],
                    // 'tax_value' => $product['tax_value'],
                    // 'tax' => $product['tax'],
                    // 'taxAmount' => $product['taxAmount'],
                    'price' => $product['price'],
                    'slug' => $slug,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }

            return response()->json(['message' => 'Warehouse tranfer added','status'=>200],200);

        }else{

            $userDetails = $this->userDetails($request);

            if($userDetails[0] == 'user'){
                if($userDetails[1]->user_type == 'Staff'){
                    $user_id = $userDetails[1]->reporting_id;
                }else{
                    $user_id = $userDetails[1]->id;
                }
            }else{
                $user_id = $request->user_id;
            }

            $warehouse = warehouse::where('status',1)->where('user_id', $user_id)->get();
            $product = Product::where('status',1)->where('user_id',$user_id)->get();

            $data['warehouse'] = $warehouse;
            $data['product'] = $product;

            return response()->json(['message' => 'Warehouse data', 'data' => $data ,'status'=>200],200);
        }
    }

    public function TransferIndex(Request $request){
        $query = Warehousetransfer::with('fromWarehouse','toWarehouse');

        $userDetails = $this->userDetails($request);

        if($userDetails[0] == 'user'){
            if($userDetails[1]->user_type == 'Staff'){
                $query = $query->where('user_id',$userDetails[1]->reporting_id);
            }else{
                $query = $query->where('user_id',$userDetails[1]->id);
            }
        }

        if(!empty($request->all())){
            $action = $request->action;
            $id = $request->idList;
            if($action != ''){
                if($action ==  'activate'){
                    Warehousetransfer::WhereIn('id',$id)->update(['status' => 1]);
                }else if($action == 'deactivate'){
                    Warehousetransfer::WhereIn('id',$id)->update(['status' => 0]);
                }else if($action == 'delete'){
                    Warehousetransfer::WhereIn('id',$id)->delete();
                }
            }else{
                // if($request->name != ''){
                //     $query = $query->where('product_name' , 'like' , '%'.$request->name.'%');
                // }
            }
        }

        $warehouseData = $query->get();

        global $warehouseTransferStatus;

        $statusArray = array();

        $i = 0;
        foreach($warehouseTransferStatus as $key => $status){
            $statusArray[$i]['key'] = $key;
            $statusArray[$i]['value'] = $status;

            $i++;
        }

        $data['transferStatus'] = $statusArray;
        $data['warehouseData'] = $warehouseData;

        return response()->json(['message' => 'warehouse Transfer data', 'data' => $data ,'status'=>200],200);

    }

    public function activateTransfer(Request $request, $slug = null){

        if($slug != ''){
            Warehousetransfer::Where('slug',$slug)->update(['status' => 1]);
            return response()->json(['message' => 'Warehouse tranfer activated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function deactivateTransfer(Request $request, $slug = null){
        if($slug != ''){
            Warehousetransfer::Where('slug',$slug)->update(['status' => 0]);
            return response()->json(['message' => 'Warehouse tranfer deactivated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function deleteTransfer(Request $request, $slug = null){
        if($slug != ''){
            Warehousetransfer::Where('slug',$slug)->delete();
            return response()->json(['message' => 'Warehouse tranfer deleted sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function updatestatus(Request $request){

        if(empty($request->all())){
            return response()->json(['message' => 'There was error while updating Transfer status','status'=>500],200);
        }

        $details = Warehousetransfer::where('slug',$request->slug)->first();

        $userDetails = $this->userDetails($request);

        warehouseTransferStatusHistory::insert([
            'transfer_id' => $details->id,
            'user_id' => $userDetails[1]->id,
            'status' => $request->status,
            'note' => $request->note,
            'slug' => time(),
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        Warehousetransfer::where('slug',$request->slug)->update([
            'transferstatus' => $request->status
        ]);

        return response()->json(['message' => 'Transfer status updated successfully','status'=>200],200);

    }

    public function editTransfer(Request $request, $slug = null){

        if(!empty($request->all())){
            $validatedData = Validator($request->all(),[
                'date' => 'required',
                'from_warehouse' => 'required',
                'to_warehouse' => 'required',
                'total' => 'required',
                // 'total_tax' => 'required',
                'finaltotal' => 'required'
            ]);

            if($validatedData->fails()){
                $msg = $this->validatersErrorString($validatedData->errors());

                return response()->json(['message' => $msg , 'status'=>500],200);
            }

            Warehousetransfer::where('slug',$slug)->update([
                'date' => $request->date,
                'from_warehouse' => $request->from_warehouse,
                'to_warehouse' => $request->to_warehouse,
                'shipping_cost' => $request->shipping_cost,
                // 'total_tax' => $request->total_tax,
                'finaltotal' => $request->finaltotal,
                'total' => $request->total,
            ]);

            $transfer = Warehousetransfer::where('slug',$slug)->first();

            Transferproduct::where('transfer_id',$transfer->id)->delete();


            $products = $request->products;


            foreach($products as $product){

                $slug = $this->createSlug('transferproducts',time());

                Transferproduct::insert([
                    'transfer_id' => $transfer->id,
                    'product_id' => $product['id'],
                    'quantity' => $product['quantity'],
                    // 'taxPrice' => $product['taxPrice'],
                    // 'tax_value' => $product['tax_value'],
                    // 'tax' => $product['tax'],
                    // 'taxAmount' => $product['taxAmount'],
                    'price' => $product['price'],
                    'slug' => $slug,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }

            return response()->json(['message' => 'Warehouse transfer update successfully!' , 'status' => 200],200);

        }else{
            $productorder = Warehousetransfer::where('slug',$slug)->first();
            $purchaseList = Transferproduct::with('product')->where('transfer_id',$productorder->id)->get();

            foreach($purchaseList as $key => $purchase){
                $purchaseData[$key]['id'] = $purchase->product->id;
                $purchaseData[$key]['name'] = $purchase->product->product_name;
                $purchaseData[$key]['productPrice'] = $purchase->product->products_price;
                $purchaseData[$key]['tax_method']= $purchase->product->tax_method;
                $purchaseData[$key]['product_id'] = $purchase->product_id;
                $purchaseData[$key]['quantity'] = $purchase->quantity;
                $purchaseData[$key]['taxPrice'] = $purchase->taxPrice;
                $purchaseData[$key]['tax_value'] = $purchase->tax_value;
                $purchaseData[$key]['tax'] = $purchase->tax;
                $purchaseData[$key]['taxAmount'] = $purchase->taxAmount;
                $purchaseData[$key]['price'] = $purchase->price;
            }

            $userDetails = $this->userDetails($request);

            if($userDetails[0] == 'user'){
                if($userDetails[1]->user_type == 'Staff'){
                    $user_id = $userDetails[1]->reporting_id;
                }else{
                    $user_id = $userDetails[1]->id;
                }
            }else{
                $user_id = $request->user_id;
            }

            $warehouse = Warehouse::where('status',1)->where('user_id',$user_id)->get();
            $product = Product::where('status',1)->where('user_id',$user_id)->get();

            $data['purchaseorder'] = $productorder;
            $data['purchaseList'] = $purchaseData;
            $data['warehouse'] = $warehouse;
            $data['product'] = $product;

            return response()->json(['message' => 'Transfer data' ,'data' => $data, 'status' => 200],200);

        }

    }

    public function transferStatusHistory(Request $request, $slug = null){

        if($slug==''){
            return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
        }

        $sales = Warehousetransfer::where('slug',$slug)->first();

        $history = warehouseTransferStatusHistory::where('transfer_id',$sales->id)->get();

        return response()->json(['message' => 'purchase list' ,'data' => $history , 'status' => 200],200);

    }

    public function getWarehouseProduct(Request $request, $slug = null){

        if($slug==''){
            return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
        }

        $warehouse = Warehouse::where('user_id',$slug)->get();
        $product = Product::where('user_id',$slug)->get();

        $data['warehouse'] = $warehouse;
        $data['product'] = $product;

        return response()->json(['message' => 'warehouse list' ,'data' => $data , 'status' => 200],200);

    }

}
