<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

use App\Models\Unit;

class UnitsController extends Controller
{
    //
    public function add(Request $request){

        $validatedData = Validator($request->all(),[
            'unit_code' => 'required',
            'unit_name' => 'required',
            'base_unit' => 'required',
            'operator' => 'required',
            'operator_value' => 'required',
        ]);

        if($validatedData->fails()){
            $msg = $this->validatersErrorString($validatedData->errors());

            return response()->json(['message' => $msg , 'status'=>500],200);
        }

        $slug = $this->createSlug('units',$request->unit_name);

        Unit::insert([
            'unit_code' => $request->unit_code,
            'unit_name' => $request->unit_name,
            'base_unit' => $request->base_unit,
            'operator' => $request->operator,
            'operator_value' => $request->operator_value,
            'slug' => $slug,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        return response()->json(['message' => 'Unit Add Sucessfully' , 'status'=>200],200);
    }

    public function edit(Request $request, $slug = null){

        if($slug == ''){
            return response()->json(['message' => 'invalid request slug was blank' , 'status'=>500 ],200);
        }

        if(!empty($request->all())){

            $validatedData = Validator($request->all(),[
                'unit_code' => 'required',
                'unit_name' => 'required',
                'base_unit' => 'required',
                'operator' => 'required',
                'operator_value' => 'required',
            ]);

            if($validatedData->fails()){
                $msg = $this->validatersErrorString($validatedData->errors());

                return response()->json(['message' => $msg , 'status'=>500],200);
            }

            Unit::where('slug',$slug)->update([
                'unit_code' => $request->unit_code,
                'unit_name' => $request->unit_name,
                'base_unit' => $request->base_unit,
                'operator' => $request->operator,
                'operator_value' => $request->operator_value,
            ]);

            return response()->json(['message' => 'Unit updated successfully', 'status'=>200],200);

        }else{
            $unit = Unit::where('slug',$slug)->first();
            return response()->json(['message' => 'Unit data', 'data' => $unit, 'status'=>200],200);
        }
    }

    public function activate(Request $request, $slug = null){
        if($slug != ''){
            Unit::Where('slug',$slug)->update(['status' => 1]);
            return response()->json(['message' => 'Unit activated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function deactivate(Request $request, $slug = null){
        if($slug != ''){
            Unit::Where('slug',$slug)->update(['status' => 0]);
            return response()->json(['message' => 'Unit deactivated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function delete(Request $request, $slug = null){
        if($slug != ''){
            Unit::Where('slug',$slug)->delete();
            return response()->json(['message' => 'Unit deleted sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function index(Request $request){
        $query = Unit::query();

        if(!empty($request->all())){
            $action = $request->action;
            $id = $request->idList;
            if($action != ''){
                if($action ==  'activate'){
                    Unit::WhereIn('id',$id)->update(['status' => 1]);
                }else if($action == 'deactivate'){
                    Unit::WhereIn('id',$id)->update(['status' => 0]);
                }else if($action == 'delete'){
                    Unit::WhereIn('id',$id)->delete();
                }
            }else{
                if($request->name != ''){
                    $query = $query->where('unit_name' , 'like' , '%'.$request->name.'%');
                }
            }
        }

        $brand = $query->get();

        return response()->json(['message' => 'Unit data', 'data' => $brand ,'status'=>200],200);
    }

}
