<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Validator;
use App\Models\Returns;
use App\Models\Purchaseorder;
use App\Models\ReturnProduct;
use App\Models\Purchaseorderproduct;
use App\Models\ReturnStatusHistory;
use App\Models\ReturnSalesStatusHistory;

class ReturnController extends Controller
{
    public function fileReturn(Request $request){

        if(!empty($request->all())){

            $validatedData = validator($request->all(),[
                'returnType' => 'required',
                'returnReason' => 'required',
                'order' => 'required',
            ]);

            if($validatedData->fails()){
                $msg = $this->validatersErrorString($validatedData->errors());

                return response()->json(['message' => $msg , 'status'=>500],200);
            }

            $userDetails = $this->userDetails($request);


            if($userDetails[0] == 'user'){

                if($userDetails[1]->user_type == 'Staff'){
                    $user_id = $userDetails[1]->reporting_id;
                }else{
                    $user_id = $userDetails[1]->id;
                }
            }else{
                $user_id = $request->user_id;
            }

            $Purchaseorder = Purchaseorder::where('slug',$request->order)->first();


            Purchaseorder::where('slug',$request->order)->update([
                'order_return' =>  1,
            ]);

            $slug = $this->createSlug('returns',time());

            $total = 0;
            $products = $request->products;
            foreach($products as $key => $product){
                $total = $total +$product['price'];
            }

            $return_id = Returns::insertGetId([
                'slug' => $slug,
                'return_type' => $request->returnType,
                'return_reason' => $request->returnReason,
                'pruchase_id' => $Purchaseorder->id,
                'return_to' => $Purchaseorder->seller_id,
                'return_amount' => $total,
                'discount_applicaple' => $Purchaseorder->discount,
                'user_id' => $user_id,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            // $Purchaseorderproduct = Purchaseorderproduct::where('order_id',$Purchaseorder->id)->get();

            foreach($products as $key => $product){

                $slug = $this->createSlug('return_products',time());

                ReturnProduct::insert([
                    'return_id' => $return_id,
                    'product_id' => $product['id'],
                    'quantity' => $product['quantity'],
                    // 'taxPrice' => ,
                    // 'tax_value' => ,
                    // 'tax' => ,
                    // 'taxAmount' => ,
                    'price' => $product['price'],
                    'slug' => $slug,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }



            return response()->json(['message' => 'Return created successfully','status'=>200],200);
        }else{
            return response()->json(['message' => 'There was error while creating return','status'=>500],200);
        }

    }

    public function getProducts(Request $request , $slug = null){

        $Purchaseorder = Purchaseorder::where('slug',$slug)->first();

        $Purchaseorderproduct = Purchaseorderproduct::with('product')->where('order_id',$Purchaseorder->id)->get();

        return response()->json(['message' => 'Purchase order list' ,'data' => $Purchaseorderproduct , 'status' => 200],200);
    }

    public function getPurchaseReturns(Request $request){

        $userDetails = $this->userDetails($request);

        if($userDetails[0] == 'user'){

            if($userDetails[1]->user_type == 'Staff'){
                $user_id = $userDetails[1]->reporting_id;
            }else{
                $user_id = $userDetails[1]->id;
            }
        }else{
            $user_id = $request->user_id;
        }

        global $salesStatus;
        global $salesPaymentStatus;

        $statusArray = array();

        $i = 0;
        foreach($salesStatus as $key => $status){
            $statusArray[$i]['key'] = $key;
            $statusArray[$i]['value'] = $status;
            $i++;
        }

        $paymentStatusArray = array();
        $j = 0;
        foreach($salesPaymentStatus as $k => $paymentStatus){
            $paymentStatusArray[$j]['key'] = $k;
            $paymentStatusArray[$j]['value'] = $paymentStatus;
            $j++;
        }

        $data['orderStatus'] = $statusArray;
        $data['paymentStatus'] = $paymentStatusArray;


        $Returns = Returns::with('supplierDetails')->where('user_id',$user_id)->get();

        $data['returns'] = $Returns;

        return response()->json(['message' => 'Returns list' ,'data' => $data , 'status' => 200],200);

    }

    public function getSalesReturns(Request $request){

        $userDetails = $this->userDetails($request);

        if($userDetails[0] == 'user'){

            if($userDetails[1]->user_type == 'Staff'){
                $user_id = $userDetails[1]->reporting_id;
            }else{
                $user_id = $userDetails[1]->id;
            }
        }else{
            $user_id = $request->user_id;
        }

        global $returnStatus;

        $statusArray = array();
        $i = 0;
        foreach($returnStatus as $key => $status){
            $statusArray[$i]['key'] = $key;
            $statusArray[$i]['value'] = $status;
            $i++;
        }

        $data['orderStatus'] = $statusArray;

        $Returns = Returns::with('userDetails')->where('return_to',$user_id)->get();

        $data['returns'] = $Returns;

        return response()->json(['message' => 'Returns list' ,'data' => $data, 'status' => 200],200);
    }

    public function getReturnDetails(Request $request , $slug = null){

        $Returns = Returns::where('slug',$slug)->first();

        $ReturnProduct = ReturnProduct::with('product')->where('return_id',$Returns->id)->get();

        return response()->json(['message' => 'Returns list' ,'data' => $ReturnProduct , 'status' => 200],200);
    }

    public function updateReturnStatus(Request $request){

        if($request->slug == ''){
            return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
        }

        $details = Returns::where('slug',$request->slug)->first();

        $userDetails = $this->userDetails($request);

        ReturnStatusHistory::insert([
            'return_id' => $details->id,
            'user_id' => $userDetails[1]->id,
            'status' => $request->status,
            'note' => $request->note,
            'type' => 'status',
            'slug' => time(),
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        Returns::where('slug',$request->slug)->update(['returnstatus' => $request->status]);

        return response()->json(['message' => 'Return status updated' , 'status' => 200],200);

    }

    public function updatePaymentStatus(Request $request ){
        if($request->slug == ''){
            return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
        }

        $details = Returns::where('slug',$request->slug)->first();

        $userDetails = $this->userDetails($request);

        ReturnStatusHistory::insert([
            'return_id' => $details->id,
            'user_id' => $userDetails[1]->id,
            'status' => $request->status,
            'note' => $request->note,
            'type' => 'Payment',
            'slug' => time(),
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        Returns::where('slug',$request->slug)->update(['paymentstatus' => $request->status]);

        return response()->json(['message' => 'Return payment status updated' , 'status' => 200],200);
    }

    public function updateSalesReturnStatus(Request $request){
        if($request->slug == ''){
            return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
        }

        $details = Returns::where('slug',$request->slug)->first();

        $userDetails = $this->userDetails($request);

        ReturnSalesStatusHistory::insert([
            'return_id' => $details->id,
            'user_id' => $userDetails[1]->id,
            'status' => $request->status,
            'note' => $request->note,
            'type' => 'status',
            'slug' => time(),
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        Returns::where('slug',$request->slug)->update(['salestatus' => $request->status]);

        return response()->json(['message' => 'Return status updated' , 'status' => 200],200);
    }

    public function getPurchaseReturnStatusHistory(Request $request , $slug = null){
        if($slug == ''){
            return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
        }

        $details = Returns::where('slug',$slug)->first();

        $returnHistory = ReturnStatusHistory::where('return_id',$details->id)->get();

        return response()->json(['message' => 'Returns list' ,'data' => $returnHistory , 'status' => 200],200);
    }

    public function getSalesReturnStatusHistory(Request $request , $slug = null){
        if($slug == ''){
            return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
        }

        $details = Returns::where('slug',$slug)->first();

        $returnHistory = ReturnSalesStatusHistory::where('return_id',$details->id)->get();

        return response()->json(['message' => 'Returns list' ,'data' => $returnHistory , 'status' => 200],200);
    }

    public function active(Request $request, $slug = null){
        if($slug == ''){
            return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
        }

        Returns::where('slug',$slug)->update(['status' => 1]);
        return response()->json(['message' => 'Returns activated sucessfully','status'=>200 ],200);
    }

    public function deactivate(Request $request, $slug = null){
        if($slug == ''){
            return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
        }

        Returns::where('slug',$slug)->update(['status' => 0]);
        return response()->json(['message' => 'Returns deactivated sucessfully','status'=>200 ],200);
    }

    public function updateReturn (Request $request){
        if($request->slug == ''){
            return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
        }

        Returns::where('slug',$request->slug)->update([
            'discount_removed' => $request->discount_removed,
            'comment' => $request->comment,
        ]);

        return response()->json(['message' => 'Returns updated sucessfully','status'=>200 ],200);

    }
}

?>
