<?php

namespace App\Http\Controllers\Api;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Quotation;
use App\Models\QuotationProduct;
use App\Models\Warehouse;
Use App\Models\User;
use App\Models\Product;
use App\Models\QuotationStatusHistory;
use App\Models\Purchaseorder;
use App\Models\Purchaseorderproduct;
use App\Models\PurchaseLog;


class QuotationController extends Controller
{
    public function addQuotation(Request $request){

        $userDetails = $this->userDetails($request);

        $user_id = 0;

        if($userDetails[0] == 'user'){
            if($userDetails[1]->user_type == 'Staff'){
                $user_id = $userDetails[1]->reporting_id;
            }else{
                $user_id = $userDetails[1]->id;
            }
        }

        if(!empty($request->all())){
            $validatedData = Validator($request->all(),[
                // 'date' => 'required',
                'warehouse' => 'required',
                'customer' => 'required',
                'supplier' => 'required',
                'total' => 'required',
                'total_tax' => 'required',
                'finaltotal' => 'required'
            ]);

            if($validatedData->fails()){
                $msg = $this->validatersErrorString($validatedData->errors());

                return response()->json(['message' => $msg , 'status'=>500],200);
            }

            $slug = $this->createSlug('quotations',time());


            $last_id = Quotation::max('id');

            $last_id++;

            $number = $this->generateUniqueNumber();

            $first_four = substr($number, 0, 4);

            $rest = substr($number, 4);

            $order_number = 'quote-'.$first_four.'-'.$rest.$last_id;

            $quote_id = Quotation::insertGetId([
                'user_id' => $user_id,
                // 'date' => $request->date,
                'supplier' => $request->supplier,
                'warehouse' => $request->warehouse,
                'customer' => $request->customer,
                'shipping_cost' => $request->shipping_cost,
                'total_tax' => $request->total_tax,
                'discount' => $request->discount,
                'finaltotal' => $request->finaltotal,
                'total' => $request->total,
                'order_number' => $order_number,
                'slug' => $slug,
                'status' => 1,
                'quotations_status' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ]);


            $products = $request->products;

            foreach($products as $product){

                $slug = $this->createSlug('quotation_products',time());

                QuotationProduct::insert([
                    'quotation_id' => $quote_id,
                    'product_id' => $product['id'],
                    'quantity' => $product['quantity'],
                    'taxPrice' => $product['taxPrice'],
                    'tax_value' => $product['tax_value'],
                    'tax' => $product['tax'],
                    'taxAmount' => $product['taxAmount'],
                    'price' => $product['price'],
                    'slug' => $slug,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }

            return response()->json(['message' => 'Quotation added successfully' , 'status'=>200],200);

        }else{

            $warehouse = Warehouse::where('status',1)->where('user_id',$user_id)->get();
            $customer = User::where('status',1)->where('reporting_id',$user_id)->where('id' ,'<>' ,$user_id)->where('user_type', '<>' ,'Staff')->select('id','full_name')->get();
            $supplier = User::where('status',1)->where('reporting_id',$user_id)->where('id' ,'<>' ,$user_id)->where('user_type', '<>' ,'Staff')->select('id','full_name')->get();
            // $product = Product::where('status',1)->where('user_id',)->get();

            $data['warehouse'] = $warehouse;
            $data['customer'] = $customer;
            $data['supplier'] = $supplier;
            // $data['product'] = $product;

            return response()->json(['message' => 'quotation order data' , 'data' => $data , 'status'=>200],200);
        }

    }

    public function indexQuotation(Request $request){

        $query = Quotation::with('warehouseDetails','customerDetails','supplierDetails');

        $userDetails = $this->userDetails($request);

        if($userDetails[0] == 'user'){
            if($userDetails[1]->user_type == 'Staff'){
                $query = $query->where('user_id',$userDetails[1]->reporting_id);
            }else{
                $query = $query->where('user_id',$userDetails[1]->id);
            }
        }

        if(!empty($request->all())){
            $action = $request->action;
            $id = $request->idList;
            if($action != ''){
                if($action ==  'activate'){
                    Quotation::WhereIn('id',$id)->update(['status' => 1]);
                }else if($action == 'deactivate'){
                    Quotation::WhereIn('id',$id)->update(['status' => 0]);
                }else if($action == 'delete'){
                    Quotation::WhereIn('id',$id)->delete();
                }
            }else{
                // if($request->name != ''){
                //     $query = $query->where('product_name' , 'like' , '%'.$request->name.'%');
                // }
            }
        }

        $quotationOrder = $query->get();

        global $quotationStatus;

        $statusArray = array();

        $i = 0;
        foreach($quotationStatus as $key => $quotation){
            $statusArray[$i]['key'] = $key;
            $statusArray[$i]['value'] = $quotation;
            $i++;
        }

        $data['quotationStatus'] = $statusArray;
        $data['quotationOrder'] = $quotationOrder;

        return response()->json(['message' => 'Quotation Order Data', 'data' => $data ,'status'=>200],200);

    }

    public function activate(Request $request, $slug = null){

        if($slug != ''){
            Quotation::Where('slug',$slug)->update(['status' => 1]);
            return response()->json(['message' => 'Quotation activated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function deactivate(Request $request, $slug = null){

        if($slug != ''){
            Quotation::Where('slug',$slug)->update(['status' => 0]);
            return response()->json(['message' => 'Quotation deactivated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function delete(Request $request, $slug = null){
        if($slug != ''){
            Quotation::Where('slug',$slug)->delete();
            return response()->json(['message' => 'Quotation deleted sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function updatestatus(Request $request){

        if(empty($request->all())){
            return response()->json(['message' => 'There was error while updating sale order status','status'=>500],200);
        }

        $details = Quotation::where('slug',$request->slug)->first();

        $userDetails = $this->userDetails($request);

        QuotationStatusHistory::insert([
            'quote_id' => $details->id,
            'user_id' => $userDetails[1]->id,
            'status' => $request->status,
            'note' => $request->note,
            'slug' => time(),
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        Quotation::where('slug',$request->slug)->update([
            'quotations_status' => $request->status
        ]);

        return response()->json(['message' => 'Sale order status updated successfully','status'=>200],200);
    }

    public function quotationHistory(Request $request, $slug = null){

        if($slug==''){
            return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
        }

        $sales = Quotation::where('slug',$slug)->first();

        $history = QuotationStatusHistory::where('quote_id',$sales->id)->get();

        return response()->json(['message' => 'purchase list' ,'data' => $history , 'status' => 200],200);

    }

    public function editQuotation(Request $request, $slug = null){
        if(!empty($request->all())){

            $validatedData = Validator($request->all(),[
                'supplier' => 'required',
                'warehouse' => 'required',
                'customer' => 'required',
                'total' => 'required',
                'total_tax' => 'required',
                'finaltotal' => 'required'
            ]);

            if($validatedData->fails()){
                $msg = $this->validatersErrorString($validatedData->errors());

                return response()->json(['message' => $msg , 'status'=>500],200);
            }

            Quotation::where('slug',$slug)->update([
                // 'date' => $request->date,
                'supplier' => $request->supplier,
                'warehouse' => $request->warehouse,
                'customer' => $request->customer,
                'shipping_cost' => $request->shipping_cost,
                'total_tax' => $request->total_tax,
                'discount' => $request->discount,
                'finaltotal' => $request->finaltotal,
                'total' => $request->total,
            ]);

            $productorder = Quotation::where('slug',$slug)->first();

            QuotationProduct::where('quotation_id',$productorder->id)->delete();

            $products = $request->products;

            foreach($products as $product){

                $slug = $this->createSlug('quotation_products',time());

                QuotationProduct::insert([
                    'quotation_id' => $productorder->id,
                    'product_id' => $product['id'],
                    'quantity' => $product['quantity'],
                    'taxPrice' => $product['taxPrice'],
                    'tax_value' => $product['tax_value'],
                    'tax' => $product['tax'],
                    'taxAmount' => $product['taxAmount'],
                    'price' => $product['price'],
                    'slug' => $slug,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }

            return response()->json(['message' => 'Sales order updated sucessfully' , 'status'=>200],200);

        }else{
            $productorder = Quotation::where('slug',$slug)->first();
            $purchaseList = QuotationProduct::with('product')->where('quotation_id',$productorder->id)->get();

            foreach($purchaseList as $key => $purchase){
                $purchaseData[$key]['id'] = $purchase->product->id;
                $purchaseData[$key]['name'] = $purchase->product->product_name;
                $purchaseData[$key]['productPrice'] = $purchase->product->products_price;
                $purchaseData[$key]['tax_method']= $purchase->product->tax_method;
                $purchaseData[$key]['product_id'] = $purchase->product_id;
                $purchaseData[$key]['quantity'] = $purchase->quantity;
                $purchaseData[$key]['taxPrice'] = $purchase->taxPrice;
                $purchaseData[$key]['tax_value'] = $purchase->tax_value;
                $purchaseData[$key]['tax'] = $purchase->tax;
                $purchaseData[$key]['taxAmount'] = $purchase->taxAmount;
                $purchaseData[$key]['price'] = $purchase->price;
            }

            $warehouse = Warehouse::where('status',1)->where('user_id',$productorder->user_id)->get();
            $customer = User::where('status',1)->where('user_type','Customer')->where('reporting_id',$productorder->user_id)->select('id','full_name')->get();
            $supplier = User::where('status',1)->where('user_type','Supplier')->where('reporting_id',$productorder->user_id)->select('id','full_name')->get();
            $product = Product::where('status',1)->where('warehouse',$productorder->warehouse)->get();

            $data['purchaseorder'] = $productorder;
            $data['purchaseList'] = $purchaseData;
            $data['warehouse'] = $warehouse;
            $data['customer'] = $customer;
            $data['supplier'] = $supplier;
            $data['product'] = $product;

            return response()->json(['message' => 'purchase list' ,'data' => $data ,'status' => 200],200);
        }
    }

    public function convertToSales(Request $request , $slug = null){
        if($slug == null){
            return response()->json(['message' => 'Please provide quotation slug' ,'status' => 500],200);
        }

        $quotation = Quotation::where('slug',$slug)->first();

        Quotation::where('slug',$slug)->update([
            'is_order' => 1
        ]);

        $QuotationProducts = QuotationProduct::where('quotation_id',$quotation->id)->delete();

        $userDetails = $this->userDetails($request);

        $user_id = 0;

        if($userDetails[0] == 'user'){
            $login_user = $userDetails[1]->id;
            if($userDetails[1]->user_type == 'Staff'){
                $user_id = $userDetails[1]->reporting_id;
            }else{
                $user_id = $userDetails[1]->id;
            }
        }

        $last_id = Purchaseorder::max('id');

        $last_id++;

        $number = $this->generateUniqueNumber();

        $first_four = substr($number, 0, 4);

        $rest = substr($number, 4);

        $order_number = 'order-'.$first_four.'-'.$rest.$last_id;

        $order_id = Purchaseorder::insertGetId([
            'user_id' => $user_id,
            'date' => date('Y-m-d'),
            'warehouse' => $quotation->warehouse,
            'buyer_id' => $quotation->customer,
            'seller_id' => $quotation->supplier,
            'shipping_cost' => $quotation->shipping_cost,
            'total_tax' => $quotation->total_tax,
            'discount' => $quotation->discount,
            'finaltotal' => $quotation->finaltotal,
            'total' => $quotation->total,
            'slug' => $slug,
            'order_number' => $order_number,
            'orderstatus' => 4,
            'paymentstatus' => 1,
            'salestatus' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        foreach($QuotationProducts as $product){
            $slug = $this->createSlug('purchaseorderproducts',time());

            Purchaseorderproduct::insert([
                'order_id' => $order_id,
                'product_id' => $product->id,
                'quantity' => $product->quantity,
                'taxPrice' => $product->taxPrice,
                'tax_value' => $product->tax_value,
                'tax' => $product->tax,
                'taxAmount' => $product->taxAmount,
                'price' => $product->price,
                'slug' => $slug,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            // PurchaseLog::insert([
            //     'order_id' => $order_id,
            //     'action' => 'Added',
            //     'quantity' => $product->quantity,
            //     'product_id' => $product->id,
            //     'user_id' => $login_user,
            //     'created_at' => now(),
            //     'updated_at' => now(),
            // ]);
        }

        return response()->json(['message' => 'Sales order created' ,'status' => 200],200);

    }

}
