<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Purchaseorder;
use App\Models\Purchaseorderproduct;
use App\Models\Warehouse;
use App\Models\User;
use App\Models\Product;
use App\Models\PurchaseOrderStatusHistory;
// use App\Models\PurchaseLog;
use App\Models\PurchaseorderHistory;
// use App\Models\PurchaseorderproductsLog;
// use App\Models\PurchaseordersLog;
use Illuminate\Support\Facades\Validator;

use PDF;

class OrderController extends Controller
{
    public function addPurchase(Request $request){

        if(!empty($request->all())){

            $validatedData = Validator($request->all(),[
                'date' => 'required',
                // 'warehouse' => 'required',
                'seller_id' => 'required',
                'total' => 'required',
                'total_tax' => 'required',
                'finaltotal' => 'required'
            ]);

            if($validatedData->fails()){
                $msg = $this->validatersErrorString($validatedData->errors());

                return response()->json(['message' => $msg , 'status'=>500],200);
            }

            $slug = $this->createSlug('purchaseorders',time());

            // global $orderStatus;

            $userDetails = $this->userDetails($request);

            if($userDetails[0] == 'user'){

                $login_user = $userDetails[1]->id;

                if($userDetails[1]->user_type == 'Staff'){
                    $user_id = $userDetails[1]->reporting_id;
                }else{
                    $user_id = $userDetails[1]->id;
                }
            }else{
                $user_id = $request->user_id;
            }

            $last_id = Purchaseorder::max('id');

            $last_id++;

            $number = $this->generateUniqueNumber();

            $first_four = substr($number, 0, 4);

            $rest = substr($number, 4);

            $order_number = 'order-'.$first_four.'-'.$rest.$last_id;

            $order_id = Purchaseorder::insertGetId([
                'user_id' => $user_id,
                'date' => $request->date,
                'shipping_address' => $request->shipping_address,
                'shipping_warehouse' => $request->shipping_warehouse,
                // 'warehouse' => $request->warehouse,
                'seller_id' => $request->seller_id,
                'buyer_id' => $user_id,
                'shipping_cost' => $request->shipping_cost,
                'total_tax' => $request->total_tax,
                'discount' => $request->discount,
                'finaltotal' => $request->finaltotal,
                'total' => $request->total,
                'slug' => $slug,
                'order_number' => $order_number,
                'orderstatus' => 4,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            $products = $request->products;

            foreach($products as $product){

                $slug = $this->createSlug('purchaseorderproducts',time());

                Purchaseorderproduct::insert([
                    'order_id' => $order_id,
                    'product_id' => $product['id'],
                    'quantity' => $product['quantity'],
                    'taxPrice' => $product['taxPrice'],
                    'tax_value' => $product['tax_value'],
                    'tax' => $product['tax'],
                    'taxAmount' => $product['taxAmount'],
                    'price' => $product['price'],
                    'slug' => $slug,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);

                // PurchaseLog::insert([
                //     'order_id' => $order_id,
                //     'action' => 'Added',
                //     'quantity' => $product['quantity'],
                //     'product_id' => $product['id'],
                //     'user_id' => $login_user,
                //     'created_at' => now(),
                //     'updated_at' => now(),
                // ]);
            }

            return response()->json(['message' => 'Purchase order created sucessfully' , 'status'=>200],200);
        }else{


            $userDetails = $this->userDetails($request);

            if($userDetails[0] == 'user'){

                $login_user = $userDetails[1]->id;

                if($userDetails[1]->user_type == 'Staff'){
                    $user_id = $userDetails[1]->reporting_id;
                }else{
                    $user_id = $userDetails[1]->id;
                }
            }else{
                $user_id = $request->user_id;
            }

            $warehouse = Warehouse::where('status',1)->where('user_id' , $user_id )->get();
            $supplier = User::where('status',1)->where('user_type', '<>' , 'Staff' )->where('id', '<>' , $user_id )->select('id','full_name','company_name')->get();
            // $product = Product::where('status',1)->get();

            $data['warehouse'] = $warehouse;
            $data['supplier'] = $supplier;
            $data['product'] = '';

            return response()->json(['message' => 'Purchase order data sucessfully' , 'data' => $data , 'status'=>200],200);

        }
    }

    public function index(Request $request){

        $query = Purchaseorder::with('warehouseDetails','supplierDetails');

        $userDetails = $this->userDetails($request);

        if($userDetails[0] == 'user'){

            if($userDetails[1]->user_type == 'Staff'){
                $query = $query->where('buyer_id',$userDetails[1]->reporting_id);
            }else{
                $query = $query->where('buyer_id',$userDetails[1]->id);
            }
        }

        if(!empty($request->all())){
            $action = $request->action;
            $id = $request->idList;
            if($action != ''){
                if($action ==  'activate'){
                    Purchaseorder::WhereIn('id',$id)->update(['status' => 1]);
                }else if($action == 'deactivate'){
                    Purchaseorder::WhereIn('id',$id)->update(['status' => 0]);
                }else if($action == 'delete'){
                    Purchaseorder::WhereIn('id',$id)->delete();
                }
            }else{
                // if($request->name != ''){
                //     $query = $query->where('product_name' , 'like' , '%'.$request->name.'%');
                // }
            }
        }

        $Purchaseorder = $query->get();

        global $orderStatus;

        $statusArray = array();

        $i = 0;
        foreach($orderStatus as $key => $status){
            $statusArray[$i]['key'] = $key;
            $statusArray[$i]['value'] = $status;

            $i++;
        }

        $data['orderStatus'] = $statusArray;
        $data['purchaseorder'] = $Purchaseorder;

        return response()->json(['message' => 'Purchaseorder data', 'data' => $data ,'status'=>200],200);

    }

    public function activate(Request $request, $slug = null){

        if($slug != ''){
            Purchaseorder::Where('slug',$slug)->update(['status' => 1]);
            return response()->json(['message' => 'Purchase order activated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function deactivate(Request $request, $slug = null){

        if($slug != ''){
            Purchaseorder::Where('slug',$slug)->update(['status' => 0]);
            return response()->json(['message' => 'Purchase order deactivated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function delete(Request $request, $slug = null){
        if($slug != ''){
            Purchaseorder::Where('slug',$slug)->delete();
            return response()->json(['message' => 'Purchase order deleted sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function updatestatus(Request $request){

        if(empty($request->all())){
            return response()->json(['message' => 'There was error while updating purchase order status','status'=>500],200);
        }

        $details = Purchaseorder::where('slug',$request->slug)->first();

        $userDetails = $this->userDetails($request);

        PurchaseOrderStatusHistory::insert([
            'order_id' => $details->id,
            'user_id' => $userDetails[1]->id,
            'status' => $request->status,
            'type' => 'Status',
            'note' => $request->note,
            'slug' => time(),
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        Purchaseorder::where('slug',$request->slug)->update([
            'orderstatus' => $request->status
        ]);


        return response()->json(['message' => 'Purchase order status updated successfully','status'=>200],200);

    }

    public function genratePDF(Request $request , $slug = null){

        $query = Purchaseorder::with('warehouseDetails','supplierDetails','orderTable','customerDetails');

        $query = $query->where('slug',$slug);

        $Purchaseorder = $query->first();

        global $orderStatus;

        $statusArray = array();

        $i = 0;
        foreach($orderStatus as $key => $status){
            $statusArray[$i]['key'] = $key;
            $statusArray[$i]['value'] = $status;
            $i++;
        }

        $data['orderStatus'] = $statusArray;
        $data['purchaseorder'] = $Purchaseorder;

        // exit();

        // return view('order.purchasepdf',['purchaseorder' => $Purchaseorder , 'orderStatus' => $statusArray]);


        $pdf = PDF::loadView("order.purchasepdf" , ['purchaseorder' => $Purchaseorder , 'orderStatus' => $statusArray]);

        // $pdf = PDF::loadView('pdf', compact('show'));

        return $pdf->download('invoice.pdf');

    }

    public function edit(Request $request, $slug = null){

        if(!empty($request->all())){

            $validatedData = Validator($request->all(),[
                'date' => 'required',
                // 'warehouse' => 'required',
                'seller_id' => 'required',
                'total' => 'required',
                'total_tax' => 'required',
                'finaltotal' => 'required'
            ]);

            if($validatedData->fails()){
                $msg = $this->validatersErrorString($validatedData->errors());

                return response()->json(['message' => $msg , 'status'=>500],200);
            }

            // insert changes
            $old_Purchaseorder = Purchaseorder::where('slug',$slug)->first();

            $field_updates = json_decode($request->updates,true);

            $productUpdates = json_decode($request->productUpdates,true);

            $userDetails = $this->userDetails($request);
            $login_user = $userDetails[1]->id;

            foreach($field_updates as $key => $value){

                if($value['field'] != "" ){
                    $value['field'];

                    $field_name = $this->getUserField($value['field']);

                    $field_slug = $this->createSlug('purchaseorder_histories',time());

                    PurchaseorderHistory::insert([
                        'order_id' => $old_Purchaseorder->id,
                        'user_id' => $login_user,
                        'field' => $field_name,
                        'old_value' => $value['oldvalue'],
                        'new_value' => $value['newvalue'],
                        'comment' => '',
                        'operation' => $value['operation'],
                        'created_at' => now(),
                        'updated_at' => now(),
                        'slug' => $field_slug,
                    ]);
                }
            }

            foreach($productUpdates as $value){
                if($value['productId'] != ""){

                    $field_slug = $this->createSlug('purchaseorder_histories',time());

                    PurchaseorderHistory::insert([
                        'order_id' => $old_Purchaseorder->id,
                        'user_id' => $login_user,
                        'field' => 'product-'.$value['productId'],
                        'old_value' => $value['oldvalue'],
                        'new_value' => $value['newvalue'],
                        'comment' => '',
                        'operation' => $value['operation'],
                        'created_at' => now(),
                        'updated_at' => now(),
                        'slug' => $field_slug,
                    ]);
                }
            }


            //update
            Purchaseorder::where('slug',$slug)->update([
                'date' => $request->date,
                'shipping_warehouse' => $request->shipping_warehouse,
                'shipping_address' => $request->shipping_address,
                'seller_id' => $request->seller_id,
                'shipping_cost' => $request->shipping_cost,
                'total_tax' => $request->total_tax,
                'discount' => $request->discount,
                'finaltotal' => $request->finaltotal,
                'total' => $request->total,
            ]);


            // $slug_log = $this->createSlug('purchaseorders_logs',time());

            // $PurchaseordersLog_id = PurchaseordersLog::insertGetId([
            //     'order_id' => $old_Purchaseorder->id,
            //     'user_id' => $old_Purchaseorder->user_id,
            //     'date' => $old_Purchaseorder->date,
            //     'warehouse' => $old_Purchaseorder->warehouse,
            //     'seller_id' => $old_Purchaseorder->seller_id,
            //     'buyer_id' => $old_Purchaseorder->buyer_id,
            //     'shipping_cost' => $old_Purchaseorder->shipping_cost,
            //     'total_tax' => $old_Purchaseorder->total_tax,
            //     'discount' => $old_Purchaseorder->discount,
            //     'finaltotal' => $old_Purchaseorder->finaltotal,
            //     'total' => $old_Purchaseorder->total,
            //     'slug' => $slug_log,
            //     'created_at' => now(),
            //     'updated_at' => now(),
            // ]);


            $productorder = Purchaseorder::where('slug',$slug)->first();

            // $old_values = Purchaseorderproduct::where('order_id',$productorder->id)->get();
            // $old_count = Purchaseorderproduct::where('order_id',$productorder->id)->count();

            Purchaseorderproduct::where('order_id',$productorder->id)->delete();


            $products = $request->products;

            foreach($products as $product){

                $slug = $this->createSlug('purchaseorderproducts',time());

                Purchaseorderproduct::insert([
                    'order_id' => $productorder->id,
                    'product_id' => $product['id'],
                    'quantity' => $product['quantity'],
                    'taxPrice' => $product['taxPrice'],
                    'tax_value' => $product['tax_value'],
                    'tax' => $product['tax'],
                    'taxAmount' => $product['taxAmount'],
                    'price' => $product['price'],
                    'slug' => $slug,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);

                // $setOldvalue = new \stdClass();
                // $i = 0;
                // $found = false;

                // foreach($old_values as $old_value){
                //     $i++;
                //     if($old_value->product_id == $product['id']){

                //         $found = true;
                //         $setOldvalue = $old_value;
                //         break;
                //     }
                // }

                // if($found == false){
                //     $action =  'Added';

                //     PurchaseLog::insert([
                //         'order_id' => $productorder->id,
                //         'action' => 'Added',
                //         'quantity' => $product['quantity'],
                //         'product_id' => $product['id'],
                //         'user_id' => $login_user,
                //         'created_at' => now(),
                //         'updated_at' => now(),
                //     ]);

                // }else{
                //     $action =  'Updated';

                //     if($setOldvalue->quantity != $product['quantity']){
                //         PurchaseLog::insert([
                //             'order_id' => $productorder->id,
                //             'action' => 'Updated',
                //             'quantity' => $product['quantity'],
                //             'product_id' => $product['id'],
                //             'user_id' => $login_user,
                //             'created_at' => now(),
                //             'updated_at' => now(),
                //         ]);
                //     }
                // }

            }

            // $products = Purchaseorderproduct::where('order_id',$productorder->id)->get();

            // foreach($old_values as $old_value){

                // $slug = $this->createSlug('purchaseorderproducts_logs',time());

                // PurchaseorderproductsLog::insert([
                //     'order_id' => $PurchaseordersLog_id,
                //     'product_id' => $old_value->id,
                //     'quantity' => $old_value->quantity,
                //     'taxPrice' => $old_value->taxPrice,
                //     'tax_value' => $old_value->tax_value,
                //     'tax' => $old_value->tax,
                //     'taxAmount' => $old_value->taxAmount,
                //     'price' => $old_value->price,
                //     'slug' => $slug,
                //     'created_at' => now(),
                //     'updated_at' => now(),
                // ]);


                // $found = false;
                // foreach($products as $product){
                //     if($old_value->product_id == $product->product_id){
                //         $found = true;
                //         break;
                //     }
                // }

                // if($found == false ){
                //     PurchaseLog::insert([
                //         'order_id' => $productorder->id,
                //         'action' => 'Deleted',
                //         'quantity' => $old_value->quantity,
                //         'product_id' => $old_value->product_id,
                //         'user_id' => $login_user,
                //         'created_at' => now(),
                //         'updated_at' => now(),
                //     ]);
                // }

            // }

            return response()->json(['message' => 'Purchase order updated sucessfully' , 'status'=>200],200);

        }else{

            $productorder = Purchaseorder::where('slug',$slug)->first();
            $purchaseList = Purchaseorderproduct::with('product')->where('order_id',$productorder->id)->get();

            foreach($purchaseList as $key => $purchase){
                $purchaseData[$key]['id'] = $purchase->product->id;
                $purchaseData[$key]['name'] = $purchase->product->product_name;
                $purchaseData[$key]['productPrice'] = $purchase->product->products_price;
                $purchaseData[$key]['tax_method']= $purchase->product->tax_method;
                $purchaseData[$key]['product_id'] = $purchase->product_id;
                $purchaseData[$key]['quantity'] = $purchase->quantity;
                $purchaseData[$key]['taxPrice'] = $purchase->taxPrice;
                $purchaseData[$key]['tax_value'] = $purchase->tax_value;
                $purchaseData[$key]['tax'] = $purchase->tax;
                $purchaseData[$key]['taxAmount'] = $purchase->taxAmount;
                $purchaseData[$key]['price'] = $purchase->price;
            }

            $seller_id = $productorder->seller_id;
            $buyer_id = $productorder->buyer_id;

            $userDetails = $this->userDetails($request);

            if($userDetails[0] == 'user'){
                if($userDetails[1]->user_type == 'Staff'){
                    $user_id = $userDetails[1]->reporting_id;
                    //$query = $query->where('user_id',$userDetails[1]->reporting_to);
                }else{
                    $user_id = $userDetails[1]->id;
                    // $query = $query->where('user_id',$userDetails[1]->id);
                }
            }


            $warehouse = Warehouse::where('status',1)->where('user_id',$buyer_id)->get();
            // $supplier = User::where('status',1)->where('user_type','Supplier')->select('id','full_name','company_name')->get();
            $supplier = User::where('status',1)->where('user_type','<>','Staff')->where('id','<>',$user_id)->select('id','full_name','company_name')->get();
            $product = Product::where('status',1)->where('user_id',$seller_id)->get();

            $data['purchaseorder'] = $productorder;
            $data['purchaseList'] = $purchaseData;
            $data['warehouse'] = $warehouse;
            $data['supplier'] = $supplier;
            $data['product'] = $product;
            $data['edit'] = $user_id == $productorder->user_id ? false : true;

            return response()->json(['message' => 'purchase list' ,'data' => $data , 'status' => 200],200);

        }
    }

    public function orderStatusHistory(Request $request, $slug = null){

        if($slug==''){
            return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
        }

        $sales = Purchaseorder::where('slug',$slug)->first();

        $history = PurchaseOrderStatusHistory::where('order_id',$sales->id)->get();

        return response()->json(['message' => 'purchase list' ,'data' => $history , 'status' => 200],200);

    }

    public function genrateInvoice(Request $request, $slug = null){
        $query = Purchaseorder::with('warehouseDetails','supplierDetails','orderTable','customerDetails');

        $query = $query->where('slug',$slug);

        $Purchaseorder = $query->first();

        global $orderStatus;

        $statusArray = array();

        global $orderStatus;

        $statusArray = array();

        $i = 0;
        foreach($orderStatus as $key => $status){
            $statusArray[$i]['key'] = $key;
            $statusArray[$i]['value'] = $status;
            $i++;
        }

        $data['orderStatus'] = $statusArray;
        $data['purchaseorder'] = $Purchaseorder;

        $pdf = PDF::loadView("order.invoice" , ['purchaseorder' => $Purchaseorder , 'orderStatus' => $statusArray]);

        // $pdf = PDF::loadView('pdf', compact('show'));

        return $pdf->download('invoice.pdf');

    }

    public function getProducts(Request $request , $slug = null){
        if($slug==''){
            return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
        }

        $products = Product::where('status',1)->where('user_id',$slug)->get();

        return response()->json(['message' => 'product list' ,'data' => $products , 'status' => 200],200);
    }

    public function getlog(Request $request , $slug = null){
        if($slug==''){
            return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
        }

        $purchase = Purchaseorder::where('slug',$slug)->first();

        // PurchaseordersLog::where('',)

        // $logs = PurchaseLog::with('product' , 'user')->where('order_id',$purchase->id)->get();

        $mainlog = PurchaseorderHistory::with('user')->where('order_id',$purchase->id)->get();

        $data = array();

        foreach($mainlog as $key => $value){
            $field = $value->field;
            $oldvalue = $value->old_value;
            $newvalue = $value->new_value;

            $actualData = $this->getActualValue($field, $oldvalue, $newvalue);

            $data[$key]['user'] = $value->user->full_name;
            $data[$key]['created_at'] = $value->created_at;
            $data[$key]['operation'] = $value->operation;

            if(count($actualData) >= 3){
                $data[$key]['field'] = $actualData[2];
            }else{
                $data[$key]['field'] = $field;
            }

            $data[$key]['oldvalue'] = $actualData[0];
            $data[$key]['newvalue'] = $actualData[1];
        }

        return response()->json(['message' => 'purchase list' ,'data' => $data , 'status' => 200],200);

    }

    public function cancelOrder(Request $request, $slug = null){
        if($slug == ''){
            return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
        }

        Purchaseorder::where('slug',$slug)->update([
            'order_cancelled' => 1
        ]);

        $userDetails = $this->userDetails($request);
        $login_user = $userDetails[1]->id;

        $details = Purchaseorder::where('slug',$slug)->first();

        PurchaseorderHistory::insert([
            'order_id' => $details->id,
            'user_id' => $login_user,
            'field' => 'order_cancelled',
            'value' => 'Order has been cancelled',
            'slug' => time(),
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        return response()->json(['message' => 'Order cancelled successfully' , 'status' => 200],200);
    }

    public function getUserField($field = null){
        switch($field){
            case 'date':
                return 'Date';
                break;
            case 'seller_id':
                return 'Supplier';
                break;
            case 'shipping_address':
                return 'Ship to Address';
                break;
            case 'shipping_warehouse':
                return 'Ship to Warehouse';
                break;
            case 'shipping_cost':
                return 'Shipping cost';
                break;
            default:
                return 0;
                break;
        }
    }

    public function getActualValue($field, $old_value, $new_value){

        $field_array = explode('-',$field);

        $field = $field_array[0];

        switch($field){
            case 'Supplier':
                $user_old = User::where('id',$old_value)->select('full_name')->get();
                $user_new = User::where('id',$new_value)->select('full_name')->get();
                return [$user_old->full_name,$user_new->full_name];
                break;
            case 'Pickup Warehouse':
                $warehouse_old = Warehouse::where('id',$old_value)->select('warehouse_name')->first();
                $warehouse_new = Warehouse::where('id',$new_value)->select('warehouse_name')->first();
                return [ isset($warehouse_old->warehouse_name) ? $warehouse_old->warehouse_name : '' ,isset($warehouse_new->warehouse_name)? $warehouse_new->warehouse_name : ''];
                break;
            case 'Ship to Warehouse':
                $warehouse_old = Warehouse::where('id',$old_value)->select('warehouse_name')->first();
                $warehouse_new = Warehouse::where('id',$new_value)->select('warehouse_name')->first();
                return [ isset($warehouse_old->warehouse_name) ? $warehouse_old->warehouse_name : '' ,isset($warehouse_new->warehouse_name)? $warehouse_new->warehouse_name : ''];
                break;
            case 'product':
                $product = Product::where('id',$field_array[1])->select('product_name')->first();
                return [$old_value,$new_value,'Product '.$product->product_name];
                break;
            default:
                return [$old_value,$new_value];
                break;
        }
    }
}
