<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;

use App\Models\Country;

class CountriesController extends Controller
{
    public function add(Request $request){

        $validatedData = Validator($request->all(),[
            'name' => 'required|unique:countries,name'
        ]);

        if($validatedData->fails()){
            $msg = $this->validatersErrorString($validatedData->errors());

            return response()->json(['message' => $msg , 'status'=>500],200);
        }

        $slug = $this->createSlug('countries',$request->name);

        Country::insert([
            'name' => $request->name,
            'slug' => $slug,
            'status' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        return response()->json(['message' => 'Country Added Successfully', 'status'=>200],200);
    }

    public function edit(Request $request, $slug = null){
        if($slug == ''){
            return response()->json(['message' => 'invalid request slug was blank' , 'status'=>500 ],200);
        }

        if(!empty($request->all())){

            $validatedData = Validator($request->all(),[
                'name' => ['required',
                    Rule::unique('countries')->where(function ($query) use ($slug) {
                        $query->where('slug','<>',$slug);
                    })]
            ]);

            if($validatedData->fails()){
                $msg = $this->validatersErrorString($validatedData->errors());

                return response()->json(['message' => $msg , 'status'=>500],200);
            }

            Country::where('slug',$slug)->update([
                'name' => $request->name,
            ]);

        }else{
            $country = Country::where('slug',$slug)->first();

            return response()->json(['message' => 'Country data' , 'data' => $country , 'status' => 200],200);
        }
    }

    public function activate(Request $request, $slug = null){
        if($slug != ''){
            Country::Where('slug',$slug)->update(['status' => 1]);
            return response()->json(['message' => 'Country activated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function deactivate(Request $request, $slug = null){
        if($slug != ''){
            Country::Where('slug',$slug)->update(['status' => 0]);
            return response()->json(['message' => 'Country deactivated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function delete(Request $request, $slug = null){
        if($slug != ''){
            Country::Where('slug',$slug)->delete();
            return response()->json(['message' => 'Country deleted sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function index(Request $request){
        $query = Country::query();

        if(!empty($request->all())){
            $action = $request->action;
            $id = $request->idList;
            if($action != ''){
                if($action ==  'activate'){
                    Country::WhereIn('id',$id)->update(['status' => 1]);
                }else if($action == 'deactivate'){
                    Country::WhereIn('id',$id)->update(['status' => 0]);
                }else if($action == 'delete'){
                    Country::WhereIn('id',$id)->delete();
                }
            }else{
                if($request->name != ''){
                    $query = $query->where('brand_name' , 'like' , '%'.$request->name.'%');
                }
            }
        }

        $country = $query->get();

        return response()->json(['message' => 'country data', 'data' => $country ,'status'=>200],200);
    }


}
