<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;

use App\Models\Brand;

class BrandsController extends Controller
{
    public function add(Request $request){

        $userDetails = $this->userDetails($request);

        $user_id = 0;

        if($userDetails[0] == 'user'){
            if($userDetails[1]->user_type == 'Staff'){
                $user_id = $userDetails[1]->reporting_id;
            }else{
                $user_id = $userDetails[1]->id;
            }
        }

        $validatedData = Validator($request->all(),[
            'brand_name' => ['required',
                Rule::unique('brands')->where(function ($query) use ($user_id){
                    $query->where('user_id',$user_id);
                }),
            ],

            'brand_image' => 'required|file|max:2048|mimes:jpeg,jpg,png',
        ]);

        if($validatedData->fails()){
            $msg = $this->validatersErrorString($validatedData->errors());

            return response()->json(['message' => $msg , 'status'=>500],200);
        }


        $slug = $this->createSlug('brands',$request->brand_name);

        $customPath = UPLOAD_FULL_BRAND_IMAGE_PATH;
        $profileFileName = bin2hex(openssl_random_pseudo_bytes(4)).'_.'. $request->file('brand_image')->getClientOriginalExtension();
        // $filePath = $request->file('brand_image')->store($customPath . $profileFileName);

        $filePath = $request->file('brand_image')->move($customPath , $profileFileName);

        Brand::insert([
            'user_id' => $user_id,
            'brand_name' => $request->brand_name,
            'brand_image' => $profileFileName,
            'slug' => $slug,
            'status' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        return response()->json(['message' => 'Brand created sucessfully' , 'status'=>200],200);

    }

    public function edit(Request $request, $slug = null){

        if($slug == ""){
            return response()->json(['message' => 'invalid request slug was blank' , 'status'=>500 ],200);
        }

        $userDetails = $this->userDetails($request);

        $user_id = 0;

        if($userDetails[0] == 'user'){
            if($userDetails[1]->user_type == 'Staff'){
                $user_id = $userDetails[1]->reporting_to;
            }else{
                $user_id = $userDetails[1]->id;
            }
        }

        if(!empty($request->all())){

            $validatedData = Validator($request->all(),[
                'brand_name' => ['required',
                    Rule::unique('brands')->where(function ($query) use ($slug,$user_id){
                        return $query->where('user_id',$user_id)->where('slug','<>',$slug);
                    })],
                'brand_image' => 'nullable|file|max:2048|mimes:jpeg,jpg,png',
            ]);

            if($validatedData->fails()){
                $msg = $this->validatersErrorString($validatedData->errors());

                return response()->json(['message' => $msg , 'status'=>500],200);
            }

            if ($request->hasFile('brand_image') && $request->file('brand_image')->getClientOriginalExtension() != '') {
                $customPath = UPLOAD_FULL_BRAND_IMAGE_PATH;
                $profileFileName = bin2hex(openssl_random_pseudo_bytes(4)).'_.'. $request->file('brand_image')->getClientOriginalExtension();
                $filePath = $request->file('brand_image')->move($customPath , $profileFileName);
            }else{
                $brand = Brand::where('slug',$slug)->first();
                $profileFileName = $brand->brand_image;
            }

            Brand::where('slug',$slug)->update([
                'brand_name' => $request->brand_name,
                'brand_image' => $profileFileName,
            ]);

            return response()->json(['message' => 'Brand updated sucessfully' , 'status'=>200],200);
        }else{
            $brand = Brand::where('slug',$slug)->first();

            $brandData = array();
            $brandData['brand_name'] = $brand->brand_name;

            if(file_exists(UPLOAD_FULL_BRAND_IMAGE_PATH.$brand->brand_image) && $brand->brand_image != ''){
                $brandData['uploaded_brand_name'] = DISPLAY_FULL_BRAND_IMAGE_PATH.$brand->brand_image;
            }else{
                $brandData['uploaded_brand_name'] = '';
            }


            return response()->json(['message' => 'Brand data', 'data' => $brandData, 'status'=>200],200);
        }
    }

    public function activate(Request $request, $slug = null){
        if($slug != ''){
            Brand::Where('slug',$slug)->update(['status' => 1]);
            return response()->json(['message' => 'Brand activated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function deactivate(Request $request, $slug = null){
        if($slug != ''){
            Brand::Where('slug',$slug)->update(['status' => 0]);
            return response()->json(['message' => 'Brand deactivated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function delete(Request $request, $slug = null){
        if($slug != ''){
            Brand::Where('slug',$slug)->delete();
            return response()->json(['message' => 'Brand deleted sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function index(Request $request){
        $query = Brand::query();

        $userDetails = $this->userDetails($request);

        if($userDetails[0] == 'user'){
            if($userDetails[1]->user_type == 'Staff'){
                $query = $query->where('user_id',$userDetails[1]->reporting_id);
            }else{
                $query = $query->where('user_id',$userDetails[1]->id);
            }
        }

        if(!empty($request->all())){
            $action = $request->action;
            $id = $request->idList;
            if($action != ''){
                if($action ==  'activate'){
                    Brand::WhereIn('id',$id)->update(['status' => 1]);
                }else if($action == 'deactivate'){
                    Brand::WhereIn('id',$id)->update(['status' => 0]);
                }else if($action == 'delete'){
                    Brand::WhereIn('id',$id)->delete();
                }
            }else{
                // if($request->name != ''){
                //     $query = $query->where('brand_name' , 'like' , '%'.$request->name.'%');
                // }
            }
        }

        $brand = $query->get();

        return response()->json(['message' => 'brand data', 'data' => $brand ,'status'=>200],200);
    }

    public function DeleteImages($slug = null){
        if($slug != ""){
            $brand = Brand::where('slug',$slug)->first();

            Brand::where('slug',$slug)->update([
                'brand_image' => '',
            ]);

            @unlink(UPLOAD_FULL_BRAND_IMAGE_PATH.$brand->brand_image);

            return response()->json(['message' => 'Brand image Deleted successfully' , 'status' => 200 ],200);
        }
    }

    public function CheckBrand(Request $request){

        $userDetails = $this->userDetails($request);

        $user_id = 0;

        if($userDetails[0] == 'user'){
            if($userDetails[1]->user_type == 'Staff'){
                $user_id = $userDetails[1]->reporting_id;
            }else{
                $user_id = $userDetails[1]->id;
            }
        }

        $count = Brand::where('brand_name', 'like', '%'.$request->brand_name.'%')->where('user_id',$user_id)->count();

        if($count > 0){
            return response()->json(['message' => 'Brand name already exists' , 'status' => 500 ],200);
        }else{

            $slug = $this->createSlug('brands',$request->brand_name);

            $customPath = UPLOAD_FULL_BRAND_IMAGE_PATH;
            $profileFileName = bin2hex(openssl_random_pseudo_bytes(4)).'.'. $request->file('brand_image')->getClientOriginalExtension();
            // $filePath = $request->file('brand_image')->store($customPath . $profileFileName);

            $filePath = $request->file('brand_image')->move($customPath , $profileFileName);

            $customPathSmall = UPLOAD_SMALL_BRAND_IMAGE_PATH;

            // Define the resized image path
            $resizedFilePath = $customPathSmall . $profileFileName;

            // Resize the image to a width of 300 pixels
            $this->resizeImage($filePath, $resizedFilePath, 60);

            Brand::insert([
                'user_id' => $user_id,
                'brand_name' => $request->brand_name,
                'brand_image' => $profileFileName,
                'slug' => $slug,
                'status' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
            $brands = Brand::where('status',1)->where('user_id',$user_id)->get();

            return response()->json(['message' => 'Brand name available' , 'data' => $brands ,'status' => 200 ],200);
        }

    }
}
