<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Tymon\JWTAuth\Facades\JWTAuth;
use Illuminate\Support\Facades\Auth;

use App\Models\Admin;

class AdminsController extends Controller
{
    public function login(Request $request){
        $this->validateApiKey();
        // $pp='ims_admin';
        //  Admin::whereId(1)->update([
        //     'password'=> Hash::make($pp),
        // ]);
        // $request->validate([
        //     'username' => 'required',
        //     'password' => 'required',
        // ]);

        if (!$token = Auth::guard('admin')->attempt($request->only('username', 'password'))) {
            return response()->json(['error' => 'Unauthorized' , 'message' => 'Invalid Username or Password' , 'status' => 500 ], 200);
        }

        $admin = Admin::where('username',$request->username)->first();

        return $this->respondWithToken($token,$admin);

    }

    protected function respondWithToken($token,$admin)
    {
        return response()->json([
            'access_token' => $token,
            'first_name' => $admin->first_name,
            'last_name' => $admin->last_name,
            'status' => 200,
            // 'token_type' => 'bearer',
            // 'expires_in' => Auth::guard('admin')->factory()->getTTL() * 60,
        ],200);
    }

    public function dashboard(Request $request){
        $this->validateApiKey();
        return response()->json(['message' => 'success' ,'status' => 200],200);
    }

    public function logout()
    {
        Auth::guard('admin')->logout();

        return response()->json(['message' => 'Admin successfully logged out']);
    }
}


