<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\UsersController;
use App\Http\Controllers\Api\AdminsController;
use App\Http\Controllers\Api\BillersController;
use App\Http\Controllers\Api\BrandsController;
use App\Http\Controllers\Api\UnitsController;
use App\Http\Controllers\Api\WarehousesController;
use App\Http\Controllers\Api\CategoriesController;
use App\Http\Controllers\Api\TaxsController;
use App\Http\Controllers\Api\CustomergroupsController;
use App\Http\Controllers\Api\ExpensesController;
use App\Http\Controllers\Api\ProductsController;
use App\Http\Controllers\Api\CountriesController;
use App\Http\Controllers\Api\SupplierController;
use App\Http\Controllers\Api\OrderController;
use App\Http\Controllers\Api\CustomersController;
use App\Http\Controllers\Api\SalesController;
use App\Http\Controllers\Api\CurrencyController;
use App\Http\Controllers\Api\QuotationController;
use App\Http\Controllers\Api\ReturnController;


/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//     return $request->user();
// });

Route::any('/login',[UsersController::class,'login']);
Route::any('/register',[UsersController::class,'register']);

Route::any('/admin/login',[AdminsController::class,'login']);

Route::prefix('admin')->middleware('auth.admin')->group(function () {
    // Protected admin routes
    Route::any('/dashboard',[AdminsController::class,'dashboard']);
    Route::any('/logout',[AdminsController::class,'logout']);

    Route::any('/billerindex',[BillersController::class,'index']);
    Route::any('/addbiller',[BillersController::class,'add']);
    Route::any('/editBiller/{slug}',[BillersController::class,'edit']);
    Route::any('/Biller_activate/{slug}',[BillersController::class,'activate']);
    Route::any('/Biller_deactivate/{slug}',[BillersController::class,'deactivate']);
    Route::any('/Biller_delete/{slug}',[BillersController::class,'delete']);
    Route::any('/Biller_delete_images/{slug}',[BillersController::class,'DeleteImages']);

    Route::any('/brand_index',[BrandsController::class,'index']);
    Route::any('/brand_add',[BrandsController::class,'add']);
    Route::any('/brand_edit/{slug}',[BrandsController::class,'edit']);
    Route::any('/brand_activate/{slug}',[BrandsController::class,'activate']);
    Route::any('/brand_deactivate/{slug}',[BrandsController::class,'deactivate']);
    Route::any('/brand_delete/{slug}',[BrandsController::class,'delete']);
    Route::any('/brand_delete_image/{slug}',[BrandsController::class,'DeleteImages']);

    Route::any('/unit_index',[UnitsController::class,'index']);
    Route::any('/unit_add',[UnitsController::class,'add']);
    Route::any('/unit_edit/{slug}',[UnitsController::class,'edit']);
    Route::any('/unit_activate/{slug}',[UnitsController::class,'activate']);
    Route::any('/unit_deactivate/{slug}',[UnitsController::class,'deactivate']);
    Route::any('/unit_delete/{slug}',[UnitsController::class,'delete']);

    Route::any('/warehouse_index',[WarehousesController::class,'index']);
    Route::any('/warehouse_add',[WarehousesController::class,'add']);
    Route::any('/warehouse_edit/{slug}',[WarehousesController::class,'edit']);
    Route::any('/warehouse_activate/{slug}',[WarehousesController::class,'activate']);
    Route::any('/warehouse_deactivate/{slug}',[WarehousesController::class,'deactivate']);
    Route::any('/warehouse_delete/{slug}',[WarehousesController::class,'delete']);

    Route::any('/category_index',[CategoriesController::class,'index']);
    Route::any('/category_add',[CategoriesController::class,'add']);
    Route::any('/category_edit/{slug}',[CategoriesController::class,'edit']);
    Route::any('/category_activate/{slug}',[CategoriesController::class,'activate']);
    Route::any('/category_deactivate/{slug}',[CategoriesController::class,'deactivate']);
    Route::any('/category_delete/{slug}',[CategoriesController::class,'delete']);

    Route::any('/subcategory_index/{slug}',[CategoriesController::class,'indexSubCategory']);
    Route::any('/subcategory_add/{cslug}',[CategoriesController::class,'addSubCategory']);
    Route::any('/subcategory_edit/{cslug}/{slug}',[CategoriesController::class,'editSubCategory']);
    Route::any('/subcategory_activate/{slug}',[CategoriesController::class,'activateSubCategory']);
    Route::any('/subcategory_deactivate/{slug}',[CategoriesController::class,'deactivateSubCategory']);
    Route::any('/subcategory_delete/{slug}',[CategoriesController::class,'deleteSubCategory']);
    Route::any('/get_subcategory/{slug}',[CategoriesController::class,'getSubCategory']);

    Route::any('/tax_index',[TaxsController::class,'index']);
    Route::any('/tax_add',[TaxsController::class,'add']);
    Route::any('/tax_edit/{slug}',[TaxsController::class,'edit']);
    Route::any('/tax_activate/{slug}',[TaxsController::class,'activate']);
    Route::any('/tax_deactivate/{slug}',[TaxsController::class,'deactivate']);
    Route::any('/tax_delete/{slug}',[TaxsController::class,'delete']);

    Route::any('/customergroup_index',[CustomergroupsController::class,'index']);
    Route::any('/customergroup_add',[CustomergroupsController::class,'add']);
    Route::any('/customergroup_edit/{slug}',[CustomergroupsController::class,'edit']);
    Route::any('/customergroup_activate/{slug}',[TaxsController::class,'activate']);
    Route::any('/customergroup_deactivate/{slug}',[TaxsController::class,'deactivate']);
    Route::any('/customergroup_delete/{slug}',[TaxsController::class,'delete']);

    Route::any('/expense_category_index',[ExpensesController::class,'indexCategory']);
    Route::any('/expense_category_add',[ExpensesController::class,'addCategory']);
    Route::any('/expense_category_edit/{slug}',[ExpensesController::class,'editCategory']);
    Route::any('/expense_category_activate/{slug}',[ExpensesController::class,'activateCategory']);
    Route::any('/expense_category_deactivate/{slug}',[ExpensesController::class,'deactivateCategory']);
    Route::any('/expense_category_delete/{slug}',[ExpensesController::class,'deleteCategory']);

    Route::any('/expense_index/{slug}',[ExpensesController::class,'index']);
    Route::any('/expense_add/{slug}',[ExpensesController::class,'add']);
    Route::any('/expense_edit/{slug}/{wslug}',[ExpensesController::class,'edit']);
    Route::any('/expense_activate/{slug}',[TaxsController::class,'activate']);
    Route::any('/expense_deactivate/{slug}',[TaxsController::class,'deactivate']);
    Route::any('/expense_delete/{slug}',[TaxsController::class,'delete']);

    Route::any('/product_index',[ProductsController::class,'index']);
    Route::any('/product_add',[ProductsController::class,'add']);
    Route::any('/product_edit/{slug}',[ProductsController::class,'edit']);
    Route::any('/product_activate/{slug}',[ProductsController::class,'activate']);
    Route::any('/product_deactivate/{slug}',[ProductsController::class,'deactivate']);
    Route::any('/product_delete/{slug}',[ProductsController::class,'delete']);
    Route::any('/product_delete_image/{slug}',[ProductsController::class,'DeleteImages']);
    Route::any('/product_delete_variant/{slug}',[ProductsController::class,'DeleteVariant']);

    Route::any('/country_add',[CountriesController::class,'add']);
    Route::any('/country_index',[CountriesController::class,'index']);
    Route::any('/country_edit/{slug}',[CountriesController::class,'edit']);
    Route::any('/country_activate/{slug}',[CountriesController::class,'activate']);
    Route::any('/country_deactivate/{slug}',[CountriesController::class,'deactivate']);
    Route::any('/country_delete/{slug}',[CountriesController::class,'delete']);

    Route::any('/supplier_add',[SupplierController::class,'add']);
    Route::any('/supplier_index',[SupplierController::class,'index']);
    Route::any('/supplier_edit/{slug}',[SupplierController::class,'edit']);
    Route::any('/supplier_activate/{slug}',[SupplierController::class,'activate']);
    Route::any('/supplier_deactivate/{slug}',[SupplierController::class,'deactivate']);
    Route::any('/supplier_delete/{slug}',[SupplierController::class,'delete']);
    Route::any('/supplier_profile_image_delete/{slug}',[SupplierController::class,'DeleteImages']);
    Route::any('/supplier_comp_logo_delete/{slug}',[SupplierController::class,'DeleteCompanylogo']);

    Route::any('/purchase_add',[OrderController::class,'addPurchase']);
    Route::any('/purchase_index',[OrderController::class,'index']);
    Route::any('/purchase_activate/{slug}',[OrderController::class,'activate']);
    Route::any('/purchase_deactivate/{slug}',[OrderController::class,'deactivate']);
    Route::any('/purchase_delete/{slug}',[OrderController::class,'delete']);
    Route::any('/purchase_updatestatus',[OrderController::class,'updatestatus']);

    Route::any('/genratePDF/{slug}',[OrderController::class,'genratePDF']);

    Route::any('/currency_add',[CurrencyController::class,'add']);
    Route::any('/currency_index',[CurrencyController::class,'index']);
    Route::any('/currency_edit/{slug}',[CurrencyController::class,'edit']);
    Route::any('/currency_activate/{slug}',[CurrencyController::class,'activate']);
    Route::any('/currency_deactivate/{slug}',[CurrencyController::class,'deactivate']);
    Route::any('/currency_delete/{slug}',[CurrencyController::class,'delete']);

});

Route::any('/user/genratePDF/{slug}',[OrderController::class,'genratePDF']);
Route::any('/user/genrateInvoice/{slug}',[OrderController::class,'genrateInvoice']);

Route::prefix('user')->middleware('auth.user')->group(function (){

    Route::any('/dashboard',[UsersController::class,'dashboard']);
    Route::any('/logout',[UsersController::class,'logout']);
    Route::any('/user_editProfile',[UsersController::class,'editProfile']);
    Route::any('/profile_delete_images',[UsersController::class,'DeleteImages']);
    Route::any('/access_control/{slug}',[UsersController::class,'accessControl']);

    Route::any('/updateProfileImage',[UsersController::class,'updateProfileImage']);
    Route::any('/updateLogo',[UsersController::class,'updateLogo']);
    Route::any('/updateDocument',[UsersController::class,'updateDocument']);
    Route::any('/updatePassword',[UsersController::class,'updatePassword']);
    Route::any('/updateTaxDetails',[UsersController::class,'updateTaxDetails']);

    Route::any('/product_index',[ProductsController::class,'index']);
    Route::any('/product_add',[ProductsController::class,'add']);
    Route::any('/product_edit/{slug}',[ProductsController::class,'edit']);
    Route::any('/product_activate/{slug}',[ProductsController::class,'activate']);
    Route::any('/product_deactivate/{slug}',[ProductsController::class,'deactivate']);
    Route::any('/product_delete/{slug}',[ProductsController::class,'delete']);
    Route::any('/product_delete_image/{slug}',[ProductsController::class,'DeleteImages']);
    Route::any('/product_delete_variant/{slug}',[ProductsController::class,'DeleteVariant']);

    Route::any('/purchase_add',[OrderController::class,'addPurchase']);
    Route::any('/purchase_index',[OrderController::class,'index']);
    Route::any('/purchase_edit/{slug}',[OrderController::class,'edit']);
    Route::any('/purchase_activate/{slug}',[OrderController::class,'activate']);
    Route::any('/purchase_deactivate/{slug}',[OrderController::class,'deactivate']);
    Route::any('/purchase_delete/{slug}',[OrderController::class,'delete']);
    Route::any('/purchase_updatestatus',[OrderController::class,'updatestatus']);
    Route::any('/purchase_orderStatusHistory/{slug}',[OrderController::class,'orderStatusHistory']);
    Route::any('/purchase_getProducts/{slug}',[OrderController::class,'getProducts']);
    Route::any('/purchase_getlog/{slug}',[OrderController::class,'getlog']);
    Route::any('/purchase_cancelOrder/{slug}', [OrderController::class,'cancelOrder']);

    Route::any('/staff_add',[BillersController::class,'addStaff']);
    Route::any('/staff_index',[BillersController::class,'staffIndex']);
    Route::any('/staff_edit/{slug}',[BillersController::class,'editStaff']);
    Route::any('/staff_activate/{slug}',[BillersController::class,'activateStaff']);
    Route::any('/staff_deactivate/{slug}',[BillersController::class,'deactivateStaff']);
    Route::any('/staff_delete/{slug}',[BillersController::class,'deleteStaff']);
    Route::any('/Biller_delete_images/{slug}',[BillersController::class,'DeleteImages']);

    Route::any('/warehouse_transfer_add',[WarehousesController::class,'addTransfer']);
    Route::any('/warehouse_transfer_index',[WarehousesController::class,'TransferIndex']);
    Route::any('/warehouse_transfer_edit/{slug}',[WarehousesController::class,'editTransfer']);
    Route::any('/warehouse_transfer_activate/{slug}',[WarehousesController::class,'activateTransfer']);
    Route::any('/warehouse_transfer_deactivate/{slug}',[WarehousesController::class,'deactivateTransfer']);
    Route::any('/warehouse_transfer_delete/{slug}',[WarehousesController::class,'deleteTransfer']);
    Route::any('/warehouse_transfer_updatestatus',[WarehousesController::class,'updatestatus']);
    Route::any('/warehouse_transfer_transferStatusHistory/{slug}',[WarehousesController::class,'transferStatusHistory']);

    Route::any('/customer_add',[CustomersController::class,'add']);
    Route::any('/customer_index',[CustomersController::class,'index']);
    Route::any('/customer_edit/{slug}',[CustomersController::class,'edit']);
    Route::any('/customer_activate/{slug}',[CustomersController::class,'activate']);
    Route::any('/customer_deactivate/{slug}',[CustomersController::class,'deactivate']);
    Route::any('/customer_delete/{slug}',[CustomersController::class,'delete']);
    Route::any('/customer_delete_images/{slug}',[CustomersController::class,'DeleteImages']);

    Route::any('/sales_add',[SalesController::class,'addSales']);
    Route::any('/sales_index',[SalesController::class,'index']);
    Route::any('/sales_edit/{slug}',[SalesController::class,'edit']);
    Route::any('/sales_updatestatus',[SalesController::class,'updatestatus']);
    Route::any('/sales_updatePaymentStatus',[SalesController::class,'updatePaymentStatus']);
    Route::any('/sales_activate/{slug}',[SalesController::class,'activate']);
    Route::any('/sales_deactivate/{slug}',[SalesController::class,'deactivate']);
    Route::any('/sales_delete/{slug}',[SalesController::class,'delete']);
    Route::any('/sales_orderStatusHistory/{slug}',[SalesController::class,'orderStatusHistory']);
    Route::any('/sales_acceptOrder/{slug}',[SalesController::class,'acceptOrder']);

    Route::any('/warehouse_index',[WarehousesController::class,'index']);
    Route::any('/warehouse_add',[WarehousesController::class,'add']);
    Route::any('/warehouse_edit/{slug}',[WarehousesController::class,'edit']);
    Route::any('/warehouse_activate/{slug}',[WarehousesController::class,'activate']);
    Route::any('/warehouse_deactivate/{slug}',[WarehousesController::class,'deactivate']);
    Route::any('/warehouse_delete/{slug}',[WarehousesController::class,'delete']);
    Route::any('/warehouse_getWarehouseProduct/{slug}',[WarehousesController::class,'getWarehouseProduct']);

    Route::any('/expense_index/{slug}',[ExpensesController::class,'index']);
    Route::any('/expense_add/{slug}',[ExpensesController::class,'add']);
    Route::any('/expense_edit/{slug}/{wslug}',[ExpensesController::class,'edit']);
    Route::any('/expense_activate/{slug}',[ExpensesController::class,'activate']);
    Route::any('/expense_deactivate/{slug}',[ExpensesController::class,'deactivate']);
    Route::any('/expense_delete/{slug}',[ExpensesController::class,'delete']);

    Route::any('/supplier_add',[SupplierController::class,'add']);
    Route::any('/supplier_index',[SupplierController::class,'index']);
    Route::any('/supplier_edit/{slug}',[SupplierController::class,'edit']);
    Route::any('/supplier_activate/{slug}',[SupplierController::class,'activate']);
    Route::any('/supplier_deactivate/{slug}',[SupplierController::class,'deactivate']);
    Route::any('/supplier_delete/{slug}',[SupplierController::class,'delete']);
    Route::any('/supplier_profile_image_delete/{slug}',[SupplierController::class,'DeleteImages']);
    Route::any('/supplier_comp_logo_delete/{slug}',[SupplierController::class,'DeleteCompanylogo']);

    Route::any('/quotation_addQuotation',[QuotationController::class,'addQuotation']);
    Route::any('/quotation_index',[QuotationController::class,'indexQuotation']);
    Route::any('/quotation_activate/{slug}',[QuotationController::class,'activate']);
    Route::any('/quotation_deactivate/{slug}',[QuotationController::class,'deactivate']);
    Route::any('/quotation_delete/{slug}',[QuotationController::class,'delete']);
    Route::any('/quotation_updatestatus',[QuotationController::class,'updatestatus']);
    Route::any('/quotation_quotationHistory/{slug}',[QuotationController::class,'quotationHistory']);
    Route::any('/quotation_editQuotation/{slug}',[QuotationController::class,'editQuotation']);
    Route::any('/quotation_convertToSales/{slug}',[QuotationController::class,'convertToSales']);

    Route::any('/product_getProduct/{slug}',[ProductsController::class,'getProduct']);

    Route::any('/brand_index',[BrandsController::class,'index']);
    Route::any('/brand_add',[BrandsController::class,'add']);
    Route::any('/brand_edit/{slug}',[BrandsController::class,'edit']);
    Route::any('/brand_activate/{slug}',[BrandsController::class,'activate']);
    Route::any('/brand_deactivate/{slug}',[BrandsController::class,'deactivate']);
    Route::any('/brand_delete/{slug}',[BrandsController::class,'delete']);
    Route::any('/brand_delete_image/{slug}',[BrandsController::class,'DeleteImages']);
    Route::any('/brand_checkBrand',[BrandsController::class,'CheckBrand']);

    Route::any('/category_index',[CategoriesController::class,'index']);
    Route::any('/category_add',[CategoriesController::class,'add']);
    Route::any('/category_edit/{slug}',[CategoriesController::class,'edit']);
    Route::any('/category_activate/{slug}',[CategoriesController::class,'activate']);
    Route::any('/category_deactivate/{slug}',[CategoriesController::class,'deactivate']);
    Route::any('/category_delete/{slug}',[CategoriesController::class,'delete']);
    Route::any('/category_checkCategory',[CategoriesController::class,'checkCategory']);

    Route::any('/subcategory_index/{slug}',[CategoriesController::class,'indexSubCategory']);
    Route::any('/subcategory_add/{cslug}',[CategoriesController::class,'addSubCategory']);
    Route::any('/subcategory_edit/{cslug}/{slug}',[CategoriesController::class,'editSubCategory']);
    Route::any('/subcategory_activate/{slug}',[CategoriesController::class,'activateSubCategory']);
    Route::any('/subcategory_deactivate/{slug}',[CategoriesController::class,'deactivateSubCategory']);
    Route::any('/subcategory_delete/{slug}',[CategoriesController::class,'deleteSubCategory']);
    Route::any('/get_subcategory/{slug}',[CategoriesController::class,'getSubCategory']);
    Route::any('/subcategory_checkSubCategory/{parent}',[CategoriesController::class,'checkSubCategory']);

    Route::any('/return_getProducts/{slug}',[ReturnController::class,'getProducts']);
    Route::any('/return_fileReturn',[ReturnController::class,'fileReturn']);
    Route::any('/return_getPurchaseReturns',[ReturnController::class,'getPurchaseReturns']);
    Route::any('/return_getSalesReturns',[ReturnController::class,'getSalesReturns']);
    Route::any('/return_getReturnDetails/{slug}',[ReturnController::class,'getReturnDetails']);
    Route::any('/return_updateReturnStatus',[ReturnController::class,'updateReturnStatus']);
    Route::any('/return_updatePaymentStatus',[ReturnController::class,'updatePaymentStatus']);
    Route::any('/return_updateSalesReturnStatus',[ReturnController::class,'updatePaymentStatus']);
    Route::any('/return_getPurchaseReturnStatusHistory/{slug}',[ReturnController::class,'getPurchaseReturnStatusHistory']);
    Route::any('/return_getSalesReturnStatusHistory/{slug}',[ReturnController::class,'getSalesReturnStatusHistory']);
    Route::any('/return_active/{slug}',[ReturnController::class,'active']);
    Route::any('/return_deactivate/{slug}',[ReturnController::class,'deactivate']);
    Route::any('/return_updateReturn/{slug}',[ReturnController::class,'updateReturn']);

});

