<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;

    public function warehouse()
    {
        return $this->belongsTo(Warehouse::class,'warehouse');
    }

    public function brand()
    {
        return $this->belongsTo(Brand::class,'brand');
    }

    public function category()
    {
        return $this->belongsTo(Category::class,'category');
    }

    public function subcategory()
    {
        return $this->belongsTo(Category::class,'sub_category');
    }

    public function unit()
    {
        return $this->belongsTo(Unit::class,'unit');
    }

    public function tax()
    {
        return $this->belongsTo(Tax::class,'products_tax');
    }

    


}
