<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

use App\Models\Tax;

class TaxsController extends Controller
{
    public function add(Request $request){
        $request->validate([
            'name' => 'required|unique:taxes',
            'tax_rate' => 'required',
        ]);

        $slug = $this->createSlug('taxes',$request->name);

        Tax::insert([
            'name' => $request->name,
            'tax_rate' => $request->tax_rate,
            'slug' => $slug,
            'status' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        return response()->json(['message' => 'Tax created sucessfully' , 'status'=>200],200);
    }

    public function edit(Request $request, $slug=null){

        if($slug == null){
            return response()->json(['message' => 'invalid request slug was blank' , 'status'=>500 ],200);
        }

        if(!empty($request->all())){
            $request->validate([
                'name' => [
                    'required',
                    Rule::unique('taxes')->where(function ($query) use ($slug) {
                        $query->where('slug', '<>', $slug);
                    }),
                ],
                'tax_rate' => 'required',
            ]);

            Tax::where('slug', $slug)->update([
                'name' => $request->name,
                'tax_rate' => $request->tax_rate,
            ]);

            return response()->json(['message' => 'Tax updated sucessfully' , 'status'=>200],200);

        }else{
            $tax = Tax::where('slug',$slug)->first();

            return response()->json(['message' => 'Tax data', 'data' => $tax, 'status'=>200],200);
        }
    }

    public function activate(Request $request, $slug = null){
        if($slug != ''){
            Tax::Where('slug',$slug)->update(['status' => 1]);
            return response()->json(['message' => 'Tax activated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function deactivate(Request $request, $slug = null){
        if($slug != ''){
            Tax::Where('slug',$slug)->update(['status' => 0]);
            return response()->json(['message' => 'Tax deactivated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function detete(Request $request, $slug = null){
        if($slug != ''){
            Tax::Where('slug',$slug)->delete();
            return response()->json(['message' => 'Tax deleted sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function index(Request $request){
        $query = Tax::query();

        if(!empty($request->all())){
            $action = $request->action;
            $id = $request->idList;
            if($action != ''){
                if($action ==  'activate'){
                    Tax::WhereIn('id',$id)->update(['status' => 1]);
                }else if($action == 'deactivate'){
                    Tax::WhereIn('id',$id)->update(['status' => 0]);
                }else if($action == 'delete'){
                    Tax::WhereIn('id',$id)->delete();
                }
            }else{
                if($request->name == ''){
                    $query = $query->where('name' , 'like' , '%'.$request->name.'%');
                }
            }
        }

        $Tax = $query->get();

        return response()->json(['message' => 'Tax data', 'data' => $Tax ,'status'=>200],200);
    }






}
