<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Product;

class StockController extends Controller
{
    public function Stock(Request $request){

        if(!empty($request->all())){

            $warehouse = $request->warehouse;

            $data['full_stock'] = '';

            if($request->warehouse != ''){
                $warehouseStock = Product::where('warehouse',$request->warehouse)->sum('products_price');
                $data['full_stock'] = $warehouseStock;
            }
            
            $data['partial_stock'] = '';

            if($request->category && $request->brand){
                $partial = Product::where('category',$request->category)->where('brand',$request->brand)->sum('products_price');
                $data['partial_stock'] = $partial;
            }


            return response()->json(['message' => 'stock data' , 'data' => $data, 'status'=>200],200);

        }

    }
}
