<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Validator;

use App\Models\Expense;
use App\Models\Expenscategory;
use App\Models\Warehouse;

class ExpensesController extends Controller
{
    public function add(Request $request, $slug = null){

        $warehouse = Warehouse::where('slug',$slug)->first();

        if(!empty($request->all())){

            $validatedData = Validator($request->all(),[
                'date' => 'required',
                'expenses_category' => 'required',
                // 'warehouse' => 'required',
                'expense_amount' => 'required',
                // 'assigned' => 'required',
            ]);

            if($validatedData->fails()){
                $msg = $this->validatersErrorString($validatedData->errors());

                return response()->json(['message' => $msg , 'status'=>500],200);
            }

            $slug = $this->createSlug('expenses',time());

            Expense::insert([
                'date' => $request->date,
                'expenses_category' => $request->expenses_category,
                'warehouse' => $warehouse->id,
                'expense_amount' => $request->expense_amount,
                // 'assigned' => $request->assigned,
                'slug' => $slug,
                'status' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            return response()->json(['message' => 'Expense created sucessfully' , 'status'=>200],200);
            exit();
        }else{



            $expensCategory = Expenscategory::where('status',1)->get();
            // $warehouse = Warehouse::where('status',1)->get();

            $data['expensCategory'] = $expensCategory;
            $data['warehouse'] = $warehouse;

            return response()->json(['message' => 'Expense data' , 'data' => $data, 'status'=>200],200);
        }
    }

    public function edit(Request $request, $slug = null, $wslug = null){
        if($slug == ''){
            return response()->json(['message' => 'invalid request slug was blank' , 'status'=>500 ],200);
        }

        $warehouse = Warehouse::where('slug',$wslug)->first();

        if(!empty($request->all())){
            $validatedData = Validator($request->all(),[
                'date' => 'required',
                'expenses_category' => 'required',
                // 'warehouse' => 'required',
                'expense_amount' => 'required',
                // 'assigned' => 'required',
            ]);

            if($validatedData->fails()){
                $msg = $this->validatersErrorString($validatedData->errors());

                return response()->json(['message' => $msg , 'status'=>500],200);
            }

            Expense::where('slug',$slug)->update([
                'date' => $request->date,
                'expenses_category' => $request->expenses_category,
                // 'warehouse' => $warehouse,
                'expense_amount' => $request->expense_amount,
                // 'assigned' => $request->assigned,
            ]);

            return response()->json(['message' => 'Expens updated sucessfully' , 'status'=>200],200);
        }else{

            $expensCategory = Expenscategory::where('status',1)->get();
            // $warehouse = Warehouse::where('status',1)->get();

            $data['expensCategory'] = $expensCategory;
            $data['warehouse'] = $warehouse;

            $Expense = Expense::where('slug',$slug)->first();
            $data['expense'] = $Expense;

            return response()->json(['message' => 'Expens data', 'data' => $data , 'status'=>200],200);
        }

    }

    public function activate(Request $request, $slug = null){

        if($slug != ''){
            Expense::Where('slug',$slug)->update(['status' => 1]);
            return response()->json(['message' => 'Expens activated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function deactivate(Request $request, $slug = null){

        if($slug != ''){
            Expense::Where('slug',$slug)->update(['status' => 0]);
            return response()->json(['message' => 'Expens deactivated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function delete(Request $request, $slug = null){
        if($slug != ''){
            Expense::Where('slug',$slug)->delete();
            return response()->json(['message' => 'Expens deleted sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function index(Request $request, $slug =  null){

        $warehouse = Warehouse::where('slug',$slug)->first();

        $query = Expense::with('expenscategory','warehouse')
        ->whereHas('warehouse', function ($query) use ($slug) {
            $query->where('slug', $slug);
        });

        if(!empty($request->all())){
            $action = $request->action;
            $id = $request->idList;
            if($action != ''){
                if($action ==  'activate'){
                    Expense::WhereIn('id',$id)->update(['status' => 1]);
                }else if($action == 'deactivate'){
                    Expense::WhereIn('id',$id)->update(['status' => 0]);
                }else if($action == 'delete'){
                    Expense::WhereIn('id',$id)->delete();
                }
            }else{
                if($request->name != ''){
                    $query = $query->where('group_name' , 'like' , '%'.$request->name.'%');
                }
            }
        }

        $Expense = $query->get();

        $expenseData['expense'] = $Expense;
        $expenseData['warehouse'] = $warehouse;

        return response()->json(['message' => 'Expens data', 'data' => $expenseData ,'status'=>200],200);
    }

    public function addCategory(Request $request){

        $validatedData = Validator($request->all(),[
            'name' => 'required|unique:expenscategories',
        ]);

        if($validatedData->fails()){
            $msg = $this->validatersErrorString($validatedData->errors());

            return response()->json(['message' => $msg , 'status'=>500],200);
        }

        $slug = $this->createSlug('expenscategories',$request->name);

        Expenscategory::insert([
            'name' => $request->name,
            'slug' => $slug,
            'status' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        return response()->json(['message' => 'Expenscategory created sucessfully' , 'status'=>200],200);
    }

    public function editCategory(Request $request, $slug = null){
        if($slug == ''){
            return response()->json(['message' => 'invalid request slug was blank' , 'status'=>500 ],200);
        }

        if(!empty($request->all())){

            $validatedData = Validator($request->all(),[
                'name' => [
                    'required',
                    Rule::unique('expenscategories')->where(function ($query) use ($slug) {
                        $query->where('slug', '<>', $slug);
                    }),
                ],
            ]);

            if($validatedData->fails()){
                $msg = $this->validatersErrorString($validatedData->errors());

                return response()->json(['message' => $msg , 'status'=>500],200);
            }

            Expenscategory::where('slug',$slug)->update([
                'name' => $request->name,
            ]);

            return response()->json(['message' => 'Expenscategory updated sucessfully' , 'status'=>200],200);
        }else{
            $Expenscategory = Expenscategory::where('slug',$slug)->first();

            return response()->json(['message' => 'Expenscategory data', 'data' => $Expenscategory, 'status'=>200],200);
        }
    }

    public function activateCategory(Request $request, $slug = null){

        if($slug != ''){
            Expenscategory::Where('slug',$slug)->update(['status' => 1]);
            return response()->json(['message' => 'Expenscategory activated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function deactivateCategory(Request $request, $slug = null){

        if($slug != ''){
            Expenscategory::Where('slug',$slug)->update(['status' => 0]);
            return response()->json(['message' => 'Expenscategory deactivated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function deleteCategory(Request $request, $slug = null){
        if($slug != ''){
            Expenscategory::Where('slug',$slug)->delete();
            return response()->json(['message' => 'Expenscategory deleted sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function indexCategory(Request $request){
        $query = Expenscategory::query();

        if(!empty($request->all())){
            $action = $request->action;
            $id = $request->idList;
            if($action != ''){
                if($action ==  'activate'){
                    Expenscategory::WhereIn('id',$id)->update(['status' => 1]);
                }else if($action == 'deactivate'){
                    Expenscategory::WhereIn('id',$id)->update(['status' => 0]);
                }else if($action == 'delete'){
                    Expenscategory::WhereIn('id',$id)->delete();
                }
            }else{
                if($request->name != ''){
                    $query = $query->where('name' , 'like' , '%'.$request->name.'%');
                }
            }
        }

        $Expenscategory = $query->get();

        return response()->json(['message' => 'Expenscategory data', 'data' => $Expenscategory ,'status'=>200],200);
    }
}
