<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Purchaseorder extends Model
{
    use HasFactory;

    public function warehouseDetails()
    {
        return $this->belongsTo(Warehouse::class,'warehouse');
    }

    public function supplierDetails()
    {
        return $this->belongsTo(User::class,'seller_id');
    }

    public function customerDetails()
    {
        return $this->belongsTo(User::class,'buyer_id');
    }

    public function orderTable(){
        return $this->hasMany(Purchaseorderproduct::class,'order_id','id');
    }
}
