<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Exception;


class Controller extends BaseController
{
    use AuthorizesRequests, ValidatesRequests;

    public function createSlug($table,$field){
        $slug = Str::slug($field);

        if (DB::table($table)->where('slug', $slug)->exists()) {
            $suffix = 1;
            while (DB::table($table)->where('slug', $slug . '-' . $suffix)->exists()) {
                $suffix++;
            }
            $slug = $slug . '-' . $suffix;
        }

        return $slug;
    }

    public function validateApiKey(){
        $apikey = \Request::header('key');
        if($apikey != ApiKey){
            return response()->json(['error' => 'Unauthorized'], 401);
        }
    }

    public function validatersErrorString($errors){

        $msgString='';

        foreach($errors->all() as $error){
            $msgString.=' - '.$error.'<br>';
        }

        return $msgString;
    }

    public function userDetails($request){

        $userType = $request->attributes->get('userType');
        $authUser = $request->attributes->get('authUser');

        return array($userType,$authUser);

        // return $userDetail;
    }

    public function generateUniqueNumber() {
        $microtime = microtime(true) * 10000; // Get current Unix timestamp with microseconds and multiply to avoid decimals
        $randomNumber = mt_rand(10000, 99999); // Generate a random number
        $uniqueNumber = $microtime . $randomNumber; // Concatenate the microtime and random number
        return $uniqueNumber;
    }

    function resizeImage($sourcePath, $destinationPath, $width){

        list($originalWidth, $originalHeight, $imageType) = getimagesize($sourcePath);

        $height = (int) (($originalHeight / $originalWidth) * $width);

        $image_p = imagecreatetruecolor($width, $height);

        switch ($imageType) {
            case IMAGETYPE_JPEG:
                $image = imagecreatefromjpeg($sourcePath);
                break;
            case IMAGETYPE_PNG:
                $image = imagecreatefrompng($sourcePath);
                break;
            case IMAGETYPE_GIF:
                $image = imagecreatefromgif($sourcePath);
                break;
            default:
                throw new Exception("Unsupported image type");
        }

        imagecopyresampled($image_p, $image, 0, 0, 0, 0, $width, $height, $originalWidth, $originalHeight);

        switch ($imageType) {
            case IMAGETYPE_JPEG:
                imagejpeg($image_p, $destinationPath, 90);
                break;
            case IMAGETYPE_PNG:
                imagepng($image_p, $destinationPath);
                break;
            case IMAGETYPE_GIF:
                imagegif($image_p, $destinationPath);
                break;
        }

        imagedestroy($image_p);
        imagedestroy($image);
    }

}



