<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;
use App\Models\Country;
use App\Models\Product;
use App\Models\Sale;
use App\Models\User;
use App\Models\Purchaseorder;
use App\Models\Returns;
use App\Models\Category;
use App\Models\Purchaseorderproduct;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class UsersController extends Controller
{

    public function login(Request $request){

        if (!$token = Auth::guard('user')->attempt($request->only('email', 'password'))) {
            return response()->json(['error' => 'Unauthorized' , 'message' => 'Invalid Email or Password' , 'status' => 500 ], 200);
        }

        $user = User::where('email',$request->email)->first();

        return $this->respondWithToken($token,$user);

    }

    protected function respondWithToken($token,$user)
    {
        return response()->json([
            'access_token' => $token,
            'full_name' => $user->full_name,
            'company_name' => $user->company_name,
            'user_type' => $user->user_type,
            'currency_symbol' => $user->currencydetails->code,
            'currency_short_name' => $user->currencydetails->short_name,
            'currency_full_name' => $user->currencydetails->short_name,
            'access' => isset($user->access) ? unserialize($user->access) : '',
            'slug' => $user->slug,
            'status' => 200,
            // 'token_type' => 'bearer',
            // 'expires_in' => Auth::guard('admin')->factory()->getTTL() * 60,
        ],200);
    }

    public function logout()
    {
        Auth::guard('user')->logout();

        return response()->json(['message' => 'User successfully logged out']);
    }

    public function register(Request $request){
        $data = $request->all();

        print_r($data);

    }

    public function dashboard(Request $request){

        $userDetails = $this->userDetails($request);

        if($userDetails[0] == 'user'){
            $user_id = $userDetails[1]->id;
        }

        $purchase_count = Purchaseorder::where('buyer_id', $user_id)->count();
        $total_purchase_value = Purchaseorder::where('buyer_id', $user_id)->sum('finaltotal');

        $total_return_value = Returns::where('user_id', $user_id)
        ->selectRaw('SUM(return_amount - discount_removed) as total_return')
        ->pluck('total_return')
        ->first();

        $product_inhand_quantity = Product::where('user_id',$user_id)->sum('products_quantity');

        $products_at_toberesived = Purchaseorder::where('buyer_id', $user_id)
        ->where('orderstatus','<>',1)
        ->join('purchaseorderproducts', 'purchaseorderproducts.order_id', '=', 'purchaseorders.id')
        ->sum('purchaseorderproducts.quantity');

        $supplier_count = User::where(function($query){
            $query->where('user_type','Supplier')
            ->orWhere('user_type','Both');
        })->where('reporting_id',$user_id)->count();

        $total_categories = Category::where('user_id',$user_id)->count();

        $total_sales_made = Purchaseorder::where('seller_id', $user_id)->count();
        $total_sales_value = Purchaseorder::where('seller_id', $user_id)->sum('finaltotal');

        $currentYear = Carbon::now()->year;

        $monthwisePurchaseData = DB::table('purchaseorders')
        ->select(DB::raw('YEAR(created_at) as year'), DB::raw('MONTH(created_at) as month'), DB::raw('SUM(finaltotal) as total'),DB::raw('COUNT(*) as count'))
        ->where('buyer_id', $user_id)
        ->whereYear('created_at', $currentYear)
        ->groupBy(DB::raw('YEAR(created_at)'), DB::raw('MONTH(created_at)'))
        ->orderBy(DB::raw('YEAR(created_at)'), 'asc')
        ->orderBy(DB::raw('MONTH(created_at)'), 'asc')
        ->get();

        $months = [
            'Jan' => ['total' => 0, 'count' => 0],
            'Feb' => ['total' => 0, 'count' => 0],
            'Mar' => ['total' => 0, 'count' => 0],
            'Apr' => ['total' => 0, 'count' => 0],
            'May' => ['total' => 0, 'count' => 0],
            'Jun' => ['total' => 0, 'count' => 0],
            'Jul' => ['total' => 0, 'count' => 0],
            'Aug' => ['total' => 0, 'count' => 0],
            'Sep' => ['total' => 0, 'count' => 0],
            'Oct' => ['total' => 0, 'count' => 0],
            'Nov' => ['total' => 0, 'count' => 0],
            'Dec' => ['total' => 0, 'count' => 0],
        ];

        $monthNames = [];
        $totalPurchase = [];
        $totalOrdered = [];

        foreach ($monthwisePurchaseData as $data) {
            $monthName = Carbon::create()->month($data->month)->format('M');
            $months[$monthName]['total'] = $data->total;
            $months[$monthName]['count'] = $data->count;
        }

        $monthNames = array_keys($months);
        $totalPurchase = array_column($months, 'total');
        $totalOrdered = array_column($months, 'count');

        $monthwiseSalesData = DB::table('purchaseorders')
        ->select(DB::raw('YEAR(created_at) as year'), DB::raw('MONTH(created_at) as month'), DB::raw('SUM(finaltotal) as total'),DB::raw('COUNT(*) as count'))
        ->where('seller_id', $user_id)
        ->whereYear('created_at', $currentYear)
        ->groupBy(DB::raw('YEAR(created_at)'), DB::raw('MONTH(created_at)'))
        ->orderBy(DB::raw('YEAR(created_at)'), 'asc')
        ->orderBy(DB::raw('MONTH(created_at)'), 'asc')
        ->get();

        $months = [
            'Jan' => ['total' => 0, 'count' => 0],
            'Feb' => ['total' => 0, 'count' => 0],
            'Mar' => ['total' => 0, 'count' => 0],
            'Apr' => ['total' => 0, 'count' => 0],
            'May' => ['total' => 0, 'count' => 0],
            'Jun' => ['total' => 0, 'count' => 0],
            'Jul' => ['total' => 0, 'count' => 0],
            'Aug' => ['total' => 0, 'count' => 0],
            'Sep' => ['total' => 0, 'count' => 0],
            'Oct' => ['total' => 0, 'count' => 0],
            'Nov' => ['total' => 0, 'count' => 0],
            'Dec' => ['total' => 0, 'count' => 0],
        ];

        $totalSalse = [];
        $totalDelivered = [];

        foreach ($monthwiseSalesData as $data) {
            $monthName = Carbon::create()->month($data->month)->format('M');
            $months[$monthName]['total'] = $data->total;
            $months[$monthName]['count'] = $data->count;
        }

        $totalSalse = array_column($months, 'total');
        $totalDelivered = array_column($months, 'count');

        $products = Product::whereColumn('products_quantity', '<', 'alert_quantity')
        ->orderBy('products_quantity', 'asc')
        ->take(3)
        ->get();

        $to_selling_products = Purchaseorder::where('seller_id', $user_id)
        ->where('orderstatus', '<>', 1)
        ->join('purchaseorderproducts', 'purchaseorderproducts.order_id', '=', 'purchaseorders.id')
        ->join('products', 'products.id', '=', 'purchaseorderproducts.product_id')
        ->select(
            'products.id',
            'products.product_name',
            'products.products_price',
            'products.products_quantity',
            DB::raw('SUM(tbl_purchaseorderproducts.quantity) as total_quantity')
        )
        ->groupBy('purchaseorderproducts.product_id')
        ->orderByDesc('total_quantity')
        ->take(3)
        ->get();



        $data = [
            'purchase_count' => $purchase_count,
            'total_purchase_value' => $total_purchase_value,
            'total_return_value' => $total_return_value,
            'product_inhand_quantity' => $product_inhand_quantity,
            'products_at_toberesived' => $products_at_toberesived,
            'supplier_count' => $supplier_count,
            'total_categories' => $total_categories,
            'total_sales_made' => $total_sales_made,
            'total_sales_value' => $total_sales_value,
            'monthNames' => $monthNames,
            'totalPurchase' => $totalPurchase,
            'totalSalse' => $totalSalse,
            'totalDelivered' => $totalDelivered,
            'totalOrdered' => $totalOrdered,
            'products' => $products,
            'to_selling_products' => $to_selling_products
        ];

        return response()->json(['message' => 'Dashboard Data' , 'data' => $data ,'status'=>200],200);

    }

    public function editProfile(Request $request){

        $userDetails = $this->userDetails($request);

        if($userDetails[0] == 'user'){
            $user_id = $userDetails[1]->id;
        }

        $user_details = User::where('id' , $user_id)->first();

        $slug = $user_details->slug;


        if(!empty($request->all())){

            $validatedData = Validator($request->all(),[
                'full_name' => 'required',
                'company_name' => 'required',
                'email' => [
                    'required',
                    'email',
                    Rule::unique('users')->where(function ($query) use ($slug) {
                    $query->where('slug', '<>', $slug);
                }),],
                // 'password' => 'sometimes|nullable',
                // 're_password' => 'required_with:password|same:password',
                // 'profile_doc' => 'file|max:2048|file|mimes:jpeg,jpg,png,pdf',
                // 'profile_image' => 'file|max:2048|mimes:jpeg,jpg,png,gif',
                'phone' => 'required',
                // 'tax' => 'required',
                // 'tax_percentage' => 'required',
                // 'company_logo' => 'file|max:2048|mimes:jpeg,jpg,png,gif',
                'country' => 'required',
                'state' => 'required',
                'city' => 'required',
                'address' => 'required'
            ]);

            if($validatedData->fails()){
                $msg = $this->validatersErrorString($validatedData->errors());

                return response()->json(['message' => $msg , 'status'=>500],200);
            }

            $user = User::where('slug',$slug)->first();

            if ($request->hasFile('profile_image') && $request->file('profile_image')->getClientOriginalName() != "" && $request->file('profile_image')->getClientOriginalExtension() !="" ) {
                $customPath = UPLOAD_FULL_PROFILE_IMAGE_PATH;
                $profileFileName = bin2hex(openssl_random_pseudo_bytes(4)).'_.'. $request->file('profile_image')->getClientOriginalExtension();
                $filePath = $request->file('profile_image')->move($customPath , $profileFileName);
            }else{
                $profileFileName = $user->profile_image;
            }

            if ($request->hasFile('company_logo') && $request->file('company_logo')->getClientOriginalName() != "" &&  $request->file('company_logo')->getClientOriginalExtension() !="") {
                $customPath = UPLOAD_FULL_PROFILE_IMAGE_PATH;
                $companyFileName = bin2hex(openssl_random_pseudo_bytes(4)).'_.'. $request->file('company_logo')->getClientOriginalExtension();
                $filePath = $request->file('company_logo')->move($customPath , $companyFileName);
            }else{
                $companyFileName = $user->company_logo;
            }

            if ($request->hasFile('profile_doc') && $request->file('profile_doc')->getClientOriginalName() != "" && $request->file('profile_doc')->getClientOriginalExtension() != "") {
                $customPath = UPLOAD_DOCUMENT_PATH;
                $documentFileName = bin2hex(openssl_random_pseudo_bytes(4)).'_.'. $request->file('profile_doc')->getClientOriginalExtension();
                $filePath = $request->file('profile_doc')->move($customPath , $documentFileName);
            }else{
                $documentFileName = $user->profile_doc;
            }


            User::where('slug',$slug)->update([

                'full_name' => $request->full_name,
                'company_name' => $request->company_name,
                'email' => $request->email,
                'profile_doc' => $documentFileName,
                'profile_image' => $profileFileName,
                'phone' => $request->phone,
                'tax' => $request->tax,
                'tax_percentage' => $request->tax_percentage,
                'country' => $request->country,
                'state' => $request->state,
                'city' => $request->city,
                'address' => $request->address,
                'company_logo' => $companyFileName,
            ]);

            if($request->password != ''){
                User::where('slug',$slug)->update([
                    'password' => Hash::make($request->password)
                ]);
            }

            return response()->json(['message' => 'Profile updated sucessfully' , 'status'=>200],200);
        }else{
            $Biller = User::where('slug',$slug)->first();

            $biller_data = array();

            $biller_data['full_name'] = $Biller->full_name;
            $biller_data['company_name'] = $Biller->company_name;
            $biller_data['email'] = $Biller->email;
            $biller_data['phone'] = $Biller->phone;
            $biller_data['tax'] = $Biller->tax;
            $biller_data['tax_percentage'] = $Biller->tax_percentage;
            $biller_data['country'] = $Biller->country;
            $biller_data['state'] = $Biller->state;
            $biller_data['city'] = $Biller->city;
            $biller_data['address'] = $Biller->address;

            if(file_exists(UPLOAD_FULL_PROFILE_IMAGE_PATH.$Biller->profile_image) && $Biller->profile_image != ""){
                $biller_data['uploaded_profile_image'] = DISPLAY_FULL_PROFILE_IMAGE_PATH.$Biller->profile_image;
            }

            $biller_data['profile_doc'] = $Biller->profile_doc;

            if(file_exists(UPLOAD_FULL_PROFILE_IMAGE_PATH.$Biller->company_logo) && $Biller->company_logo != ""){
                $biller_data['uploaded_company_logo'] = DISPLAY_FULL_PROFILE_IMAGE_PATH.$Biller->company_logo;
            }

            $country = Country::where('status',1)->get();

            $data['biller'] = $biller_data;
            $data['country'] = $country;

            return response()->json(['message' => 'Profile data' , 'data' => $data ,'status'=>200],200);

        }
    }

    public function DeleteImages(Request $request){

        $userDetails = $this->userDetails($request);

        if($userDetails[0] == 'user'){
            $user_id = $userDetails[1]->id;
        }

        $user_details = User::where('id' , $user_id)->first();

        $slug = $user_details->slug;

        if($slug != ""){
            $user = User::where('slug',$slug)->first();

            User::where('slug',$slug)->update([
                'profile_image' => '',
            ]);

            @unlink(UPLOAD_FULL_PROFILE_IMAGE_PATH.$user->profile_image);

            return response()->json(['message' => 'profile image Deleted successfully' , 'status' => 200 ],200);
        }
    }

    public function accessControl(Request $request, $slug = null){
        if(!empty($request->all())){

            $checkboxs = $request->checkbox;

            $access = array();
            foreach($checkboxs as $key => $checkbox){
                $access[$key]['Module'] = 1;
                $access[$key]['Add'] = isset($checkbox['Add']) ? 1 : 0;
                $access[$key]['Edit'] = isset($checkbox['Edit']) ? 1 : 0;
                $access[$key]['Delete'] = isset($checkbox['Delete']) ? 1 : 0;
            }

            User::where('slug',$slug)->update([
                'access' => serialize($access),
            ]);

            return response()->json(['message' => 'Staff access updated sucessfully' , 'status' => 200 ],200);

        }else{
            $access = User::where('slug',$slug)->select('access')->first();

            global $accesscontrol;

            $accessC = $accesscontrol;

            $accessData = isset($access->access) ? unserialize($access->access) : '' ;


            //$data['accesscontrol'] =  $accesscontrol;

            $accessArray = array();

            foreach($accessC as $key => $ac){

                $accessArray[$key]['name'] = $ac['name'];
                $accessArray[$key]['Module'] = $ac['Module'];
                $accessArray[$key]['Add'] = $ac['Add'];
                $accessArray[$key]['Edit'] = $ac['Edit'];
                $accessArray[$key]['Delete'] = $ac['Delete'];

                if(isset($accessData[$key])){
                    $accessArray[$key]['Module'] = $accessData[$key]['Module'];
                    $accessArray[$key]['Add'] = $accessData[$key]['Add'];
                    $accessArray[$key]['Edit'] = $accessData[$key]['Edit'];
                    $accessArray[$key]['Delete'] = $accessData[$key]['Delete'];
                }
            }

            $data['accesscontrol'] =  $accessArray;

            return response()->json(['message' => 'staff access data', 'data' => $data , 'status' => 200 ],200);

        }
    }

    public function updateProfileImage(Request $request){

        if(!empty($request->all())){

            $userDetails = $this->userDetails($request);

            $user_id = 0;

            if($userDetails[0] == 'user'){
                $user_id = $userDetails[1]->id;
            }

            $user = User::where('id' , $user_id)->first();

            if ($request->hasFile('profile_image') && $request->file('profile_image')->getClientOriginalName() != "" && $request->file('profile_image')->getClientOriginalExtension() !="" ) {
                $customPath = UPLOAD_FULL_PROFILE_IMAGE_PATH;
                $originalFileName = $request->file('profile_image')->getClientOriginalName();
                $profileFileName = bin2hex(openssl_random_pseudo_bytes(4)).'_'. $originalFileName;
                $filePath = $request->file('profile_image')->move($customPath , $profileFileName);
            }else{

                return response()->json(['message' => 'There Was Some Error While Uploading Profile Image' , 'status' => 500 ],200);

                $profileFileName = $user->profile_image;
            }

            User::where('id' , $user_id)->update([
                'profile_image' => $profileFileName,
            ]);

            return response()->json(['message' => 'Profile image updated successfully' , 'status' => 200 ],200);

        }else{
            $userDetails = $this->userDetails($request);

            $user_id = 0;

            if($userDetails[0] == 'user'){
                $user_id = $userDetails[1]->id;
            }

            $user = User::where('id' , $user_id)->first();

            $data['uploaded_profile_image'] = "";

            if(file_exists(UPLOAD_FULL_PROFILE_IMAGE_PATH.$user->profile_image) && $user->profile_image != ""){
                $data['uploaded_profile_image'] = DISPLAY_FULL_PROFILE_IMAGE_PATH.$user->profile_image;
            }

            return response()->json(['message' => 'Profile image' , 'data' => $data ,'status'=>200],200);

        }
    }

    public function updateLogo(Request $request){

        if(!empty($request->all())){

            $userDetails = $this->userDetails($request);

            $user_id = 0;

            if($userDetails[0] == 'user'){
                $user_id = $userDetails[1]->id;
            }

            $user = User::where('id' , $user_id)->first();

            if ($request->hasFile('company_logo') && $request->file('company_logo')->getClientOriginalName() != "" &&  $request->file('company_logo')->getClientOriginalExtension() !="") {
                $customPath = UPLOAD_FULL_PROFILE_IMAGE_PATH;
                $originalFileName = $request->file('company_logo')->getClientOriginalName();
                $companyFileName = bin2hex(openssl_random_pseudo_bytes(4)).'_'.$originalFileName;
                $filePath = $request->file('company_logo')->move($customPath , $companyFileName);
            }else{
                $companyFileName = $user->company_logo;
            }

            User::where('id' , $user_id)->update([
                'company_logo' => $companyFileName,
            ]);

            return response()->json(['message' => 'Profile image updated successfully' , 'status' => 200 ],200);

        }else{
            $userDetails = $this->userDetails($request);

            $user_id = 0;

            if($userDetails[0] == 'user'){
                $user_id = $userDetails[1]->id;
            }

            $user = User::where('id' , $user_id)->first();

            $data['uploaded_profile_logo'] = "";

            if(file_exists(UPLOAD_FULL_PROFILE_IMAGE_PATH.$user->company_logo) && $user->company_logo != ""){
                $data['uploaded_profile_logo'] = DISPLAY_FULL_PROFILE_IMAGE_PATH.$user->company_logo;
            }

            return response()->json(['message' => 'Profile image' , 'data' => $data ,'status'=>200],200);
        }
    }

    public function updateDocument(Request $request){
        if(!empty($request->all())){

            $userDetails = $this->userDetails($request);

            $user_id = 0;

            if($userDetails[0] == 'user'){
                $user_id = $userDetails[1]->id;
            }

            $user = User::where('id' , $user_id)->first();

            if ($request->hasFile('profile_doc') && $request->file('profile_doc')->getClientOriginalName() != "" && $request->file('profile_doc')->getClientOriginalExtension() != "") {
                $customPath = UPLOAD_DOCUMENT_PATH;
                $originalFileName = $request->file('profile_doc')->getClientOriginalName();
                $documentFileName = bin2hex(openssl_random_pseudo_bytes(4)).'_'.$originalFileName;
                $filePath = $request->file('profile_doc')->move($customPath , $documentFileName);
            }else{
                $documentFileName = $user->profile_doc;
            }

            User::where('id' , $user_id)->update([
                'profile_doc' => $documentFileName,
            ]);

            return response()->json(['message' => 'Profile image updated successfully' , 'status' => 200 ],200);

        }else{

            $userDetails = $this->userDetails($request);

            $user_id = 0;

            if($userDetails[0] == 'user'){
                $user_id = $userDetails[1]->id;
            }

            $user = User::where('id' , $user_id)->first();

            $data['uploaded_profile_doc'] = "";

            if(file_exists(UPLOAD_DOCUMENT_PATH.$user->profile_doc) && $user->profile_doc != ""){
                $data['uploaded_profile_doc'] = DISPLAY_DOCUMENT_PATH.$user->profile_doc;
            }

            return response()->json(['message' => 'Profile image' , 'data' => $data ,'status'=>200],200);

        }
    }

    public function updatePassword(Request $request){

        if(!empty($request->all())){
            $userDetails = $this->userDetails($request);
            $user_id = 0;
            if($userDetails[0] == 'user'){
                $user_id = $userDetails[1]->id;
            }

            $user = User::where('id' , $user_id)->first();

            if (!Hash::check($request->current_password, $user->password)) {
                return response()->json(['message' => 'Current password is incorrect', 'status' => 500], 200);
            }

            if (Hash::check($request->new_password, $user->password)) {
                return response()->json(['message' => 'New password cannot be the same as the old password', 'status' => 500], 200);
            }

            $user->password = Hash::make($request->current_password);
            $user->save();
            return response()->json(['message' => 'Password updated successfully' , 'status' => 200 ],200);
        }
    }

    public function updateTaxDetails(Request $request){
        if(!empty($request->all())){
            $userDetails = $this->userDetails($request);
            $user_id = 0;
            if($userDetails[0] == 'user'){
                $user_id = $userDetails[1]->id;
            }
            $user = User::where('id' , $user_id)->first();
            $user->tax = $request->tax;
            $user->tax_percentage = $request->tax_percentage;
            $user->save();
            return response()->json(['message' => 'Tax details updated successfully' , 'status' => 200 ],200);
        }else{

            $userDetails = $this->userDetails($request);

            if($userDetails[0] == 'user'){
                $user_id = $userDetails[1]->id;
            }
            $user = User::where('id' , $user_id)->first();

            $userDetails['currency'] = $user->currencydetails->code;
            $userDetails['tax'] = $user->tax;
            $userDetails['tax_percentage'] = $user->tax_percentage;

            return response()->json(['message' => 'Tax details' , 'data' => $userDetails ,'status'=>200],200);

        }
    }
}
