<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

// use App\Models\Sale;
// use App\Models\Salesorderproduct;
use App\Models\Warehouse;
use App\Models\User;
use App\Models\Product;
use App\Models\SalesOrderStatusHistory;
use Illuminate\Support\Facades\Validator;
use App\Models\Purchaseorder;
use App\Models\Purchaseorderproduct;
use App\Models\PurchaseLog;
use App\Models\PurchaseorderHistory;

use App\Models\PurchaseorderproductsLog;
use App\Models\PurchaseordersLog;

use Illuminate\Support\Facades\Log;

use PDF;

class SalesController extends Controller
{
    public function addSales(Request $request){
        if(!empty($request->all())){

            $validatedData = Validator($request->all(),[
                'date' => 'required',
                'warehouse' => 'required',
                'buyer_id' => 'required',
                'total' => 'required',
                'total_tax' => 'required',
                'finaltotal' => 'required'
            ]);

            if($validatedData->fails()){
                $msg = $this->validatersErrorString($validatedData->errors());

                return response()->json(['message' => $msg , 'status'=>500],200);
            }

            $slug = $this->createSlug('sales',time());

            $userDetails = $this->userDetails($request);

            if($userDetails[0] == 'user'){
                $login_user = $userDetails[1]->id;
                if($userDetails[1]->user_type == 'Staff'){
                    $user_id = $userDetails[1]->reporting_id;
                }else{
                    $user_id = $userDetails[1]->id;
                }
            }else{
                $user_id = $request->user_id;
            }

            $last_id=Purchaseorder::max('id');

            $last_id++;

            $number = $this->generateUniqueNumber();

            $first_four = substr($number, 0, 4);

            $rest = substr($number, 4);

            $order_number = 'order-'.$first_four.'-'.$rest.$last_id;

            $order_id = Purchaseorder::insertGetId([
                'user_id' => $user_id,
                'date' => $request->date,
                'shipping_warehouse' => $request->shipping_warehouse,
                'shipping_address' => $request->shipping_address,
                'warehouse' => $request->warehouse,
                'buyer_id' => $request->buyer_id,
                'seller_id' => $user_id,
                'shipping_cost' => $request->shipping_cost,
                'total_tax' => $request->total_tax,
                'discount' => $request->discount,
                'finaltotal' => $request->finaltotal,
                'total' => $request->total,
                'slug' => $slug,
                'order_number' => $order_number,
                'orderstatus' => 4,
                'paymentstatus' => 1,
                'salestatus' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            $products = $request->products;

            foreach($products as $product){

                $slug = $this->createSlug('purchaseorderproducts',time());

                Purchaseorderproduct::insert([
                    'order_id' => $order_id,
                    'product_id' => $product['id'],
                    'quantity' => $product['quantity'],
                    'taxPrice' => $product['taxPrice'],
                    'tax_value' => $product['tax_value'],
                    'tax' => $product['tax'],
                    'taxAmount' => $product['taxAmount'],
                    'price' => $product['price'],
                    'slug' => $slug,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);

                // PurchaseLog::insert([
                //     'order_id' => $order_id,
                //     'action' => 'Added',
                //     'quantity' => $product['quantity'],
                //     'product_id' => $product['id'],
                //     'user_id' => $login_user,
                //     'created_at' => now(),
                //     'updated_at' => now(),
                // ]);
            }

            return response()->json(['message' => 'Sale order created sucessfully' , 'status'=>200],200);

        }else{

            // $warehouse = Warehouse::where('status',1)->get();
            // $customer = User::where('status',1)->where('user_type','Customer')->select('id','full_name')->get();
            // $product = Product::where('status',1)->get();

            $userDetails = $this->userDetails($request);

            if($userDetails[0] == 'user'){
                if($userDetails[1]->user_type == 'Staff'){
                    $user_id = $userDetails[1]->reporting_id;
                    //$query = $query->where('user_id',$userDetails[1]->reporting_to);
                }else{
                    $user_id = $userDetails[1]->id;
                    //$query = $query->where('user_id',$userDetails[1]->id);
                }
            }

            $warehouse = Warehouse::where('status',1)->where('user_id' ,$user_id)->get();
            $customer = User::where('status',1)->where('user_type','<>','Staff')->where('id','<>',$user_id)->select('id','full_name')->get();
            $product = Product::where('status',1)->where('user_id',$user_id)->get();


            $data['warehouse'] = $warehouse;
            $data['customer'] = $customer;
            $data['product'] = $product;

            return response()->json(['message' => 'Sale order data' , 'data' => $data , 'status'=>200],200);
        }
    }

    public function index(Request $request){

        $query = Purchaseorder::with('warehouseDetails','customerDetails');

        // $query = Sale::with('warehouseDetails','customerDetails');

        $userDetails = $this->userDetails($request);

        if($userDetails[0] == 'user'){
            if($userDetails[1]->user_type == 'Staff'){
                $query = $query->where('seller_id',$userDetails[1]->reporting_id);
            }else{
                $query = $query->where('seller_id',$userDetails[1]->id);
                //$query = $query->where('user_id',$userDetails[1]->id);
            }
        }

        if(!empty($request->all())){
            $action = $request->action;
            $id = $request->idList;
            if($action != ''){
                if($action ==  'activate'){
                    Purchaseorder::WhereIn('id',$id)->update(['status' => 1]);
                }else if($action == 'deactivate'){
                    Purchaseorder::WhereIn('id',$id)->update(['status' => 0]);
                }else if($action == 'delete'){
                    Purchaseorder::WhereIn('id',$id)->delete();
                }
            }else{
                // if($request->name != ''){
                //     $query = $query->where('product_name' , 'like' , '%'.$request->name.'%');
                // }
            }
        }

        $salesOrder = $query->get();

        global $salesStatus;
        global $salesPaymentStatus;

        $statusArray = array();

        $i = 0;
        foreach($salesStatus as $key => $status){
            $statusArray[$i]['key'] = $key;
            $statusArray[$i]['value'] = $status;
            $i++;
        }

        $paymentStatusArray = array();
        $j = 0;
        foreach($salesPaymentStatus as $k => $paymentStatus){
            $paymentStatusArray[$j]['key'] = $k;
            $paymentStatusArray[$j]['value'] = $paymentStatus;
            $j++;
        }

        $data['orderStatus'] = $statusArray;
        $data['paymentStatus'] = $paymentStatusArray;
        $data['salesOrder'] = $salesOrder;

        return response()->json(['message' => 'Purchaseorder data', 'data' => $data ,'status'=>200],200);
    }

    public function updatestatus(Request $request){

        if(empty($request->all())){
            return response()->json(['message' => 'There was error while updating sale order status','status'=>500],200);
        }

        $details = Purchaseorder::where('slug',$request->slug)->first();

        $userDetails = $this->userDetails($request);

        SalesOrderStatusHistory::insert([
            'order_id' => $details->id,
            'user_id' => $userDetails[1]->id,
            'status' => $request->status,
            'note' => $request->note,
            'type' => 'Status',
            'slug' => time(),
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        Purchaseorder::where('slug',$request->slug)->update([
            'salestatus' => $request->status
        ]);

        return response()->json(['message' => 'Sale order status updated successfully','status'=>200],200);
    }

    public function updatePaymentStatus(Request $request){
        if(empty($request->all())){
            return response()->json(['message' => 'There was error while updating sale payment status','status'=>500],200);
        }


        $details = Purchaseorder::where('slug',$request->slug)->first();

        $userDetails = $this->userDetails($request);

        SalesOrderStatusHistory::insert([
            'order_id' => $details->id,
            'user_id' => $userDetails[1]->id,
            'status' => $request->status,
            'note' => $request->note,
            'type' => 'Payment',
            'slug' => time(),
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        Purchaseorder::where('slug',$request->slug)->update([
            'paymentstatus' => $request->status
        ]);

        return response()->json(['message' => 'Sale payment status updated successfully','status'=>200],200);
    }

    public function activate(Request $request, $slug = null){

        if($slug != ''){
            Purchaseorder::Where('slug',$slug)->update(['status' => 1]);
            return response()->json(['message' => 'Sale order activated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function deactivate(Request $request, $slug = null){

        if($slug != ''){
            Purchaseorder::Where('slug',$slug)->update(['status' => 0]);
            return response()->json(['message' => 'Sale order deactivated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function delete(Request $request, $slug = null){
        if($slug != ''){
            Purchaseorder::Where('slug',$slug)->delete();
            return response()->json(['message' => 'sale order deleted sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function edit(Request $request, $slug = null){
        if(!empty($request->all())){

            $validatedData = Validator($request->all(),[
                'date' => 'required',
                'warehouse' => 'required',
                'buyer_id' => 'required',
                'total' => 'required',
                'total_tax' => 'required',
                'finaltotal' => 'required'
            ]);

            if($validatedData->fails()){
                $msg = $this->validatersErrorString($validatedData->errors());

                return response()->json(['message' => $msg , 'status'=>500],200);
            }

            $old_Purchaseorder = Purchaseorder::where('slug',$slug)->first();


            $field_updates = json_decode($request->updates,true);

            $productUpdates = json_decode($request->productUpdates,true);

            $userDetails = $this->userDetails($request);
            $login_user = $userDetails[1]->id;

            foreach($field_updates as $key => $value){

                if($value['field'] != "" ){
                    $value['field'];

                    $field_name = $this->getUserField($value['field']);

                    $field_slug = $this->createSlug('purchaseorder_histories',time());

                    PurchaseorderHistory::insert([
                        'order_id' => $old_Purchaseorder->id,
                        'user_id' => $login_user,
                        'field' => $field_name,
                        'old_value' => $value['oldvalue'],
                        'new_value' => $value['newvalue'],
                        'comment' => '',
                        'operation' => $value['operation'],
                        'created_at' => now(),
                        'updated_at' => now(),
                        'slug' => $field_slug,
                    ]);
                }
            }

            foreach($productUpdates as $value){
                if($value['productId'] != ""){

                    $field_slug = $this->createSlug('purchaseorder_histories',time());

                    PurchaseorderHistory::insert([
                        'order_id' => $old_Purchaseorder->id,
                        'user_id' => $login_user,
                        'field' => 'product-'.$value['productId'],
                        'old_value' => $value['oldvalue'],
                        'new_value' => $value['newvalue'],
                        'comment' => '',
                        'operation' => $value['operation'],
                        'created_at' => now(),
                        'updated_at' => now(),
                        'slug' => $field_slug,
                    ]);
                }
            }

            Purchaseorder::where('slug',$slug)->update([
                'date' => $request->date,
                'warehouse' => $request->warehouse,
                'buyer_id' => $request->buyer_id,
                'shipping_cost' => $request->shipping_cost,
                'total_tax' => $request->total_tax,
                'discount' => $request->discount,
                'finaltotal' => $request->finaltotal,
                'total' => $request->total,
            ]);

            // $slug_log = $this->createSlug('purchaseorders_logs',time());

            // $PurchaseordersLog_id = PurchaseordersLog::insertGetId([
            //     'order_id' => $old_Purchaseorder->id,
            //     'user_id' => $old_Purchaseorder->user_id,
            //     'date' => $old_Purchaseorder->date,
            //     'warehouse' => $old_Purchaseorder->warehouse,
            //     'seller_id' => $old_Purchaseorder->seller_id,
            //     'buyer_id' => $old_Purchaseorder->buyer_id,
            //     'shipping_cost' => $old_Purchaseorder->shipping_cost,
            //     'total_tax' => $old_Purchaseorder->total_tax,
            //     'discount' => $old_Purchaseorder->discount,
            //     'finaltotal' => $old_Purchaseorder->finaltotal,
            //     'total' => $old_Purchaseorder->total,
            //     'slug' => $slug_log,
            //     'created_at' => now(),
            //     'updated_at' => now(),
            // ]);

            // $userDetails = $this->userDetails($request);
            // $login_user = $userDetails[1]->id;

            $productorder = Purchaseorder::where('slug',$slug)->first();

            // $old_values = Purchaseorderproduct::where('order_id',$productorder->id)->get();
           // $old_count = Purchaseorderproduct::where('order_id',$productorder->id)->count();

            Purchaseorderproduct::where('order_id',$productorder->id)->delete();

            $products = $request->products;

            foreach($products as $product){

                $slug = $this->createSlug('purchaseorderproducts',time());

                Purchaseorderproduct::insert([
                    'order_id' => $productorder->id,
                    'product_id' => $product['id'],
                    'quantity' => $product['quantity'],
                    'taxPrice' => $product['taxPrice'],
                    'tax_value' => $product['tax_value'],
                    'tax' => $product['tax'],
                    'taxAmount' => $product['taxAmount'],
                    'price' => $product['price'],
                    'slug' => $slug,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);


                // $setOldvalue = new \stdClass();
                // $i = 0;
                // $found = false;


                // foreach($old_values as $old_value){
                //     $i++;
                //     if($old_value->product_id == $product['id']){
                //         $found = true;
                //         $setOldvalue = $old_value;
                //         break;
                //     }
                // }

                // if($found == false ){
                //     $action =  'Added';
                //     PurchaseLog::insert([
                //         'order_id' => $productorder->id,
                //         'action' => 'Added',
                //         'quantity' => $product['quantity'],
                //         'product_id' => $product['id'],
                //         'user_id' => $login_user,
                //         'created_at' => now(),
                //         'updated_at' => now(),
                //     ]);
                // }else{
                //     $action =  'Updated';

                //     if($setOldvalue->quantity != $product['quantity']){
                //         PurchaseLog::insert([
                //             'order_id' => $productorder->id,
                //             'action' => 'Updated',
                //             'quantity' => $product['quantity'],
                //             'product_id' => $product['id'],
                //             'user_id' => $login_user,
                //             'created_at' => now(),
                //             'updated_at' => now(),
                //         ]);
                //     }
                // }
            }

            // $products = Purchaseorderproduct::where('order_id',$productorder->id)->get();

            // foreach($old_values as $old_value){

            //     $slug = $this->createSlug('purchaseorderproducts_logs',time());

            //     PurchaseorderproductsLog::insert([
            //         'order_id' => $PurchaseordersLog_id,
            //         'product_id' => $old_value->id,
            //         'quantity' => $old_value->quantity,
            //         'taxPrice' => $old_value->taxPrice,
            //         'tax_value' => $old_value->tax_value,
            //         'tax' => $old_value->tax,
            //         'taxAmount' => $old_value->taxAmount,
            //         'price' => $old_value->price,
            //         'slug' => $slug,
            //         'created_at' => now(),
            //         'updated_at' => now(),
            //     ]);

            //     // $found = false;
            //     // foreach($products as $product){
            //     //     if($old_value->product_id == $product->product_id){
            //     //         $found = true;
            //     //         break;
            //     //     }
            //     // }

            //     // if($found == false ){

            //     //     PurchaseLog::insert([
            //     //         'order_id' => $productorder->id,
            //     //         'action' => 'Deleted',
            //     //         'quantity' => $old_value->quantity,
            //     //         'product_id' => $old_value->product_id,
            //     //         'user_id' => $login_user,
            //     //         'created_at' => now(),
            //     //         'updated_at' => now(),
            //     //     ]);
            //     // }
            // }

            return response()->json(['message' => 'Sales order updated sucessfully' , 'status'=>200],200);

        }else{

            $productorder = Purchaseorder::where('slug',$slug)->first();
            $purchaseList = Purchaseorderproduct::with('product')->where('order_id',$productorder->id)->get();

            foreach($purchaseList as $key => $purchase){
                $purchaseData[$key]['id'] = $purchase->product->id;
                $purchaseData[$key]['name'] = $purchase->product->product_name;
                $purchaseData[$key]['productPrice'] = $purchase->product->products_price;
                $purchaseData[$key]['tax_method']= $purchase->product->tax_method;
                $purchaseData[$key]['product_id'] = $purchase->product_id;
                $purchaseData[$key]['quantity'] = $purchase->quantity;
                $purchaseData[$key]['taxPrice'] = $purchase->taxPrice;
                $purchaseData[$key]['tax_value'] = $purchase->tax_value;
                $purchaseData[$key]['tax'] = $purchase->tax;
                $purchaseData[$key]['taxAmount'] = $purchase->taxAmount;
                $purchaseData[$key]['price'] = $purchase->price;
            }

            $userDetails = $this->userDetails($request);

            if($userDetails[0] == 'user'){
                if($userDetails[1]->user_type == 'Staff'){
                    $user_id = $userDetails[1]->reporting_id;
                }else{
                    $user_id = $userDetails[1]->id;
                }
            }

            $warehouse = Warehouse::where('status',1)->where('user_id', $user_id)->get();
            $shipping_warehouse = Warehouse::where('status',1)->where('user_id', $productorder->buyer_id)->get();
            // $customer = User::where('status',1)->where('user_type','Customer')->select('id','full_name')->get();
            $customer = User::where('status',1)->where('id','<>',$user_id)->where('user_type','<>','Staff')->select('id','full_name')->get();
            $product = Product::where('status',1)->where('user_id',$user_id)->get();

            $data['purchaseorder'] = $productorder;
            $data['purchaseList'] = $purchaseData;
            $data['warehouse'] = $warehouse;
            $data['shipping_warehouse'] = $shipping_warehouse;
            $data['customer'] = $customer;
            $data['product'] = $product;
            $data['edit'] = $user_id == $productorder->user_id ? false : true;

            return response()->json(['message' => 'purchase list' ,'data' => $data ,'status' => 200],200);
        }
    }

    public function orderStatusHistory(Request $request, $slug = null){

        if($slug==''){
            return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
        }

        $sales = Purchaseorder::where('slug',$slug)->first();

        $history = SalesOrderStatusHistory::where('order_id',$sales->id)->get();

        return response()->json(['message' => 'purchase list' ,'data' => $history , 'status' => 200],200);

    }

    public function acceptOrder(Request $request , $slug = null){

        if($slug==''){
            return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
        }

        Purchaseorder::where('slug',$slug)->update([
            'order_accepted' => 1
        ]);

        return response()->json(['message' => 'order accepted successfully','status'=>200],200);
    }


    public function getUserField($field = null){
        switch($field){
            case 'date':
                return 'Date';
                break;
            case 'buyer_id':
                return 'Customer';
                break;
            case 'shipping_address':
                return 'Address';
                break;
            case 'warehouse':
                return 'Pickup Warehouse';
                break;
            case 'shipping_warehouse':
                return 'Ship to Warehouse';
                break;
            case 'shipping_cost':
                return 'Shipping cost';
                break;
            case 'discount':
                return 'Discount';
                break;
            default:
                return 0;
                break;
        }
    }


}
