<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Validator;

use App\Models\Product;
use App\Models\Brand;
use App\Models\Category;
use App\Models\Unit;
use App\Models\Tax;
use App\Models\Warehouse;
use App\Models\Productvariant;

class ProductsController extends Controller
{
    public function add(Request $request){
        if(!empty($request->all())){
            $validatedData = Validator($request->all(),[
                'product_name' => 'required|unique:products',
                'product_code' => 'required',
                'brand' => 'required',
                'category' => 'required',
                'unit' => 'required',
                'products_price' => 'required',
                'products_quantity' => 'required',
                'alert_quantity' => 'required',
                'products_description' => 'required',
                'tax' => 'required',
                'tax_value' => 'required',
                'tax_method' => 'required',
                // 'products_variations' => 'required',
                // 'expiry_date' => 'required',
                'batch_no' => 'required',
            ]);

            if($validatedData->fails()){
                $msg = $this->validatersErrorString($validatedData->errors());

                return response()->json(['message' => $msg , 'status'=>500],200);
            }

            $slug = $this->createSlug('products',$request->product_name);

            $customPath = UPLOAD_FULL_PRODUCT_IMAGE_PATH;
            $productImageFileName = bin2hex(openssl_random_pseudo_bytes(4)).'_.'. $request->file('product_images')->getClientOriginalExtension();
            $filePath = $request->file('product_images')->move($customPath , $productImageFileName);

            $userDetails = $this->userDetails($request);

            if($userDetails[0] == 'user'){

                if($userDetails[1]->user_type == 'Staff'){
                    $user_id = $userDetails[1]->reporting_id;
                }else{
                    $user_id = $userDetails[1]->id;
                }

            }else{
                $user_id = $request->user_id;
            }

            $productId = Product::insertGetId([
                'user_id' => $user_id,
                'product_name' => $request->product_name,
                'product_code' => $request->product_code,
                'brand' => $request->brand,
                'category' => $request->category,
                'unit' => $request->unit,
                'products_price' => $request->products_price,
                'products_quantity' => $request->products_quantity,
                'alert_quantity' => $request->alert_quantity,
                'products_description' => $request->products_description,
                'tax_value' => $request->tax_value,
                'tax' => $request->tax,
                'tax_method' => $request->tax_method,
                // 'products_variations' => $request->products_variations,
                'expiry_date' => $request->expiry_date,
                'batch_no' => $request->batch_no,
                'sale_price' => $request->sale_price,
                'sale_start_date' => $request->sale_start_date,
                'sale_end_date' => $request->sale_end_date,
                'warehouse' => $request->warehouse,
                'product_images' => $productImageFileName,
                'sub_category' => $request->sub_category,
                'slug' => $slug,
                'status' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            $variations = $request->variant;

            foreach($variations as $variation){

                if($variation['variant'] != ""){
                    if($variation['image']->isValid() && $variation['image']->getMimeType() && strpos($variation['image']->getMimeType(), 'image/') !== false){
                        $customPath = UPLOAD_FULL_PRODUCT_IMAGE_PATH;
                        $productImageFileName = $productId.bin2hex(openssl_random_pseudo_bytes(4)).'_.'. $variation['image']->getClientOriginalExtension();
                        $filePath = $variation['image']->move($customPath , $productImageFileName);
                    }else{
                        $productImageFileName = "";
                    }

                    Productvariant::insert([
                        'variant' => $variation['variant'],
                        'image' => $productImageFileName,
                        'productId' => $productId,
                        'price' => $variation['price'],
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }
            }

            return response()->json(['message' => 'Product created sucessfully' , 'status'=>200],200);

        }else{

            $userDetails = $this->userDetails($request);

            if($userDetails[0] == 'user'){

                if($userDetails[1]->user_type == 'Staff'){
                    $user_id = $userDetails[1]->reporting_id;
                }else{
                    $user_id = $userDetails[1]->id;
                }

            }else{
                $user_id = $request->user_id;
            }

            global $taxType;

            $brand = Brand::where('status',1)->where('user_id',$user_id)->get();
            $category = Category::where('status',1)->where('user_id',$user_id)->where('parent_id',0)->get();
            $unit = Unit::where('status',1)->get();
            $tax = Tax::where('status',1)->get();
            $warehouse = Warehouse::where('status',1)->where('user_id',$user_id)->get();

            $data = array();

            $resultArray = array_map(function($id, $name) {
                return array(
                    'id' => $id,
                    'name' => $name
                );
            }, array_keys($taxType), $taxType);

            $data['brand'] = $brand;
            $data['category'] = $category;
            $data['unit'] = $unit;
            $data['tax'] = $tax;
            $data['taxType'] = $resultArray;
            $data['warehouse'] = $warehouse;

            return response()->json(['message' => 'Product data' , 'data' => $data , 'status'=>200],200);
            exit();

        }

    }

    public function edit(Request $request, $slug = null){
        if($slug == ""){
            return response()->json(['message' => 'invalid request slug was blank' , 'status'=>500 ],200);
        }

        if(!empty($request->all())){
            $validatedData = Validator($request->all(),[
                'product_name' => [
                    'required',
                    Rule::unique('products')->where(function ($query) use ($slug) {
                        $query->where('slug', '<>', $slug);
                    }),
                ],
                'product_code' => 'required',
                'brand' => 'required',
                'category' => 'required',
                'unit' => 'required',
                'products_price' => 'required',
                'products_quantity' => 'required',
                'alert_quantity' => 'required',
                'products_description' => 'required',
                // 'products_tax' => 'required',
                'tax_method' => 'required',
                // 'products_variations' => 'required',
                // 'expiry_date' => 'required',
                'batch_no' => 'required',
            ]);

            if($validatedData->fails()){
                $msg = $this->validatersErrorString($validatedData->errors());

                return response()->json(['message' => $msg , 'status'=>500],200);
            }

            $Product = Product::where('slug',$slug)->first();

            if ($request->hasFile('product_images') && $request->file('product_images')->getClientOriginalExtension() != '') {
                $customPath = UPLOAD_FULL_PRODUCT_IMAGE_PATH;
                $productImageFileName = bin2hex(openssl_random_pseudo_bytes(4)).'_.'. $request->file('product_images')->getClientOriginalExtension();
                $filePath = $request->file('product_images')->move($customPath , $productImageFileName);
            }else{
                $productImageFileName = $Product->product_images;
            }

            Product::where('slug',$slug)->update([
                'product_name' => $request->product_name,
                'product_code' => $request->product_code,
                'brand' => $request->brand,
                'category' => $request->category,
                'unit' => $request->unit,
                'products_price' => $request->products_price,
                'products_quantity' => $request->products_quantity,
                'alert_quantity' => $request->alert_quantity,
                'products_description' => $request->products_description,
                'tax_value' => $request->tax_value,
                'tax' => $request->tax,
                // 'products_tax' => $request->products_tax,
                // 'tax_method' => $request->tax_method,
                // 'products_variations' => $request->products_variations,
                'expiry_date' => $request->expiry_date,
                'batch_no' => $request->batch_no,
                'sale_price' => $request->sale_price,
                'sale_start_date' => $request->sale_start_date,
                'sale_end_date' => $request->sale_end_date,
                'warehouse' => $request->warehouse,
                'product_images' => $productImageFileName,
                'sub_category' => $request->sub_category,
            ]);


            $variations = $request->variant;

            foreach($variations as $variation){

                if (!empty($variation['id'])) {
                    $productVariant = Productvariant::find($variation['id']);
                } else {
                    $productVariant = new Productvariant();
                    $productVariant->created_at = now();
                    $productVariant->updated_at = now();
                }

                if($variation['variant'] != ""){
                    if($variation['image']->isValid() && $variation['image']->getMimeType() && strpos($variation['image']->getMimeType(), 'image/') !== false){
                        $customPath = UPLOAD_FULL_PRODUCT_IMAGE_PATH;
                        $productImageFileName = $Product->id.bin2hex(openssl_random_pseudo_bytes(4)).'_.'. $variation['image']->getClientOriginalExtension();
                        $filePath = $variation['image']->move($customPath , $productImageFileName);
                        $productVariant->image = $productImageFileName;
                    }

                    $productVariant->variant = $variation['variant'];
                    $productVariant->productId = $Product->id;
                    $productVariant->price = $variation['price'];

                    $productVariant->save();

                }
            }



            return response()->json(['message' => 'Product updated sucessfully' , 'status'=>200],200);
        }else{
            global $taxType;
            $Product = Product::where('slug',$slug)->first();

            if(file_exists(UPLOAD_FULL_PRODUCT_IMAGE_PATH.$Product->product_images) && $Product->product_images !='' ){
                $Product->uploaded_product_image = DISPLAY_FULL_PRODUCT_IMAGE_PATH.$Product->product_images;
            }else{
                $Product->uploaded_product_image = "";
            }

            $subcategory =  array();

            if($Product->category != '' ){
                $subcategory = Category::where('status',1)->where('parent_id',$Product->category)->get();
            }

            // $Product->product_images = '';

            $brand = Brand::where('status',1)->get();
            $category = Category::where('status',1)->where('parent_id',0)->get();
            $unit = Unit::where('status',1)->get();
            $tax = Tax::where('status',1)->get();
            $warehouse = Warehouse::where('status',1)->get();

            $variantData = Productvariant::where('productId',$Product->id)->get();

            $variants = array();

            foreach($variantData as $key => $variant){
                $variants[$key]['id'] = $variant->id;
                $variants[$key]['variant'] = $variant->variant;
                $variants[$key]['price'] = $variant->price;

                if(file_exists(UPLOAD_FULL_PRODUCT_IMAGE_PATH.$variant->image) && $variant->image !='' ){
                    $variants[$key]['uploaded_product_var'] = DISPLAY_FULL_PRODUCT_IMAGE_PATH.$variant->image;
                }else{
                    $variants[$key]['uploaded_product_var'] = "";
                }
            }

            $data = array();

            $resultArray = array_map(function($id, $name) {
                return array(
                    'id' => $id,
                    'name' => $name
                );
            }, array_keys($taxType), $taxType);

            $data['brand'] = $brand;
            $data['category'] = $category;
            $data['unit'] = $unit;
            $data['tax'] = $tax;
            $data['taxType'] = $resultArray;
            $data['warehouse'] = $warehouse;
            $data['product'] = $Product;
            $data['subcategory'] = $subcategory;
            $data['varients'] = $variants;

            return response()->json(['message' => 'Product data', 'data' => $data, 'status'=>200],200);
        }
    }

    public function activate(Request $request, $slug = null){

        if($slug != ''){
            Product::Where('slug',$slug)->update(['status' => 1]);
            return response()->json(['message' => 'Product activated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function deactivate(Request $request, $slug = null){

        if($slug != ''){
            Product::Where('slug',$slug)->update(['status' => 0]);
            return response()->json(['message' => 'Product deactivated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function delete(Request $request, $slug = null){
        if($slug != ''){
            Product::Where('slug',$slug)->delete();
            return response()->json(['message' => 'Product deleted sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function index(Request $request){

        $query = Product::with('warehouse', 'brand', 'category', 'subcategory', 'unit', 'tax');

        $userDetails = $this->userDetails($request);

        if($userDetails[0] == 'user'){
            if($userDetails[1]->user_type == 'Staff'){
                $query = $query->where('user_id',$userDetails[1]->reporting_id);
            }else{
                $query = $query->where('user_id',$userDetails[1]->id);
            }
        }

        if(!empty($request->all())){
            $action = $request->action;
            $id = $request->idList;
            if($action != ''){
                if($action ==  'activate'){
                    Product::WhereIn('id',$id)->update(['status' => 1]);
                }else if($action == 'deactivate'){
                    Product::WhereIn('id',$id)->update(['status' => 0]);
                }else if($action == 'delete'){
                    Product::WhereIn('id',$id)->delete();
                }
            }else{
                if($request->name != ''){
                    $query = $query->where('product_name' , 'like' , '%'.$request->name.'%');
                }
            }
        }

        $Product = $query->get();

        return response()->json(['message' => 'Product data', 'data' => $Product ,'status'=>200],200);
    }

    public function DeleteImages($slug = null){
        if($slug != ""){
            $product = Product::where('slug',$slug)->first();

            Product::where('slug',$slug)->update([
                'product_images' => '',
            ]);

            @unlink(UPLOAD_FULL_PRODUCT_IMAGE_PATH.$product->product_images);

            return response()->json(['message' => 'Product image Deleted successfully' , 'status' => 200 ],200);
        }
    }

    public function DeleteVariant($slug = null){
        $variant = Productvariant::where('id',$slug)->first();

        @unlink(UPLOAD_FULL_PRODUCT_IMAGE_PATH.$variant->image);

        Productvariant::where('id',$slug)->delete();

        return response()->json(['message' => 'Product variant deleted successfully', 'status'=>200],200);
    }

    public function getProduct($slug = null){
        $products = Product::where('warehouse',$slug)->get();

        return response()->json(['message' => 'Product details', 'data' => $products ,'status'=>200],200);
    }

}


