<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Validator;

use App\Models\Customergroup;

class CustomergroupsController extends Controller
{
    public function add(Request $request){

        $validatedData = Validator($request->all(),[
            'group_name' => 'required|unique:customergroups',
            'price' => 'required',
        ]);

        if($validatedData->fails()){
            $msg = $this->validatersErrorString($validatedData->errors());

            return response()->json(['message' => $msg , 'status'=>500],200);
        }

        $slug = $this->createSlug('customergroups',$request->group_name);

        Customergroup::insert([
            'group_name' => $request->group_name,
            'price' => $request->price,
            'slug' => $slug,
            'status' => 1,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        return response()->json(['message' => 'Customergroup created sucessfully' , 'status'=>200],200);

    }

    public function edit(Request $request, $slug){
        if($slug == ''){
            return response()->json(['message' => 'invalid request slug was blank' , 'status'=>500 ],200);
        }

        if(!empty($request->all())){

            $validatedData = Validator($request->all(),[
                'group_name' => [
                    'required',
                    Rule::unique('customergroups')->where(function ($query) use ($slug) {
                        $query->where('slug', '<>', $slug);
                    }),
                ],
                'price' => 'required',
            ]);

            if($validatedData->fails()){
                $msg = $this->validatersErrorString($validatedData->errors());

                return response()->json(['message' => $msg , 'status'=>500],200);
            }

            Customergroup::where('slug', $slug)->update([
                'group_name' => $request->group_name,
                'price' => $request->price,
            ]);

            return response()->json(['message' => 'Customergroup updated sucessfully' , 'status'=>200],200);
        }else{
            $Customergroup = Customergroup::where('slug',$slug)->first();

            return response()->json(['message' => 'Customergroup data', 'data' => $Customergroup, 'status'=>200],200);
        }
    }

    public function activate(Request $request, $slug = null){

        if($slug != ''){
            Customergroup::Where('slug',$slug)->update(['status' => 1]);
            return response()->json(['message' => 'Customergroup activated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function deactivate(Request $request, $slug = null){

        if($slug != ''){
            Customergroup::Where('slug',$slug)->update(['status' => 0]);
            return response()->json(['message' => 'Customergroup deactivated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function delete(Request $request, $slug = null){
        if($slug != ''){
            Customergroup::Where('slug',$slug)->delete();
            return response()->json(['message' => 'Customergroup deleted sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function index(Request $request){
        $query = Customergroup::query();

        if(!empty($request->all())){
            $action = $request->action;
            $id = $request->idList;
            if($action != ''){
                if($action ==  'activate'){
                    Customergroup::WhereIn('id',$id)->update(['status' => 1]);
                }else if($action == 'deactivate'){
                    Customergroup::WhereIn('id',$id)->update(['status' => 0]);
                }else if($action == 'delete'){
                    Customergroup::WhereIn('id',$id)->delete();
                }
            }else{
                if($request->name != ''){
                    $query = $query->where('group_name' , 'like' , '%'.$request->name.'%');
                }
            }
        }

        $customergroup = $query->get();

        return response()->json(['message' => 'Customergroup data', 'data' => $customergroup ,'status'=>200],200);
    }

}
