<?php

namespace App\Http\Controllers\Api;
use App\Http\Controllers\Controller;

use App\Models\Currency;
use Illuminate\Http\Request;

class CurrencyController extends Controller
{
    public function add(Request $request){
        if(!empty($request->all())){

            // print_r($request->all());
            // exit();


            $validatedData = Validator($request->all(),[
                'code' => 'required',
                'full_name' => 'required',
                'short_name' => 'required',
            ]);

            if($validatedData->fails()){
                $msg = $this->validatersErrorString($validatedData->errors());

                return response()->json(['message' => $msg , 'status'=>500],200);
            }

            $slug = $this->createSlug('currencies',$request->full_name);

            Currency::insert([
                'code' => $request->code,
                'full_name' => $request->full_name,
                'short_name' => $request->short_name,
                'slug' => $slug,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            return response()->json(['message' => 'currency added sucessfully' , 'status'=>200],200);
        }
    }

    public function edit(Request $request, $slug = null){
        if(!empty($request->all())){

            $validatedData = Validator($request->all(),[
                'code' => 'required',
                'full_name' => 'required',
                'short_name' => 'required',
            ]);

            if($validatedData->fails()){
                $msg = $this->validatersErrorString($validatedData->errors());

                return response()->json(['message' => $msg , 'status'=>500],200);
            }

            Currency::where('slug',$slug)->update([
                'code' => $request->code,
                'full_name' => $request->full_name,
                'short_name' => $request->short_name,
            ]);

            return response()->json(['message' => 'currency edit sucessfully' , 'status'=>200],200);

        }else{
            $currency = Currency::where('slug',$slug)->first();

            return response()->json(['message' => 'currency data', 'data' => $currency , 'status'=>200],200);
        }
    }

    public function index(Request $request){

        $query = Currency::query();

        if(!empty($request->all())){
            $id = $request->idList;
            $action = $request->action;
            if($action != ''){
                if($action ==  'activate'){
                    Currency::WhereIn('id',$id)->update(['status' => 1]);
                }else if($action == 'deactivate'){
                    Currency::WhereIn('id',$id)->update(['status' => 0]);
                }else if($action == 'delete'){
                    Currency::WhereIn('id',$id)->delete();
                }
            }else{
                if($request->name != ''){
                    $query = $query->where('full_name' , 'like' , '%'.$request->name.'%');
                }
            }
        }

        $currency = $query->get();

        return response()->json(['message' => 'currency data', 'data' => $currency ,'status'=>200],200);

    }

    public function activate(Request $request, $slug = null){

        if($slug != ''){
            Currency::Where('slug',$slug)->update(['status' => 1]);
            return response()->json(['message' => 'Currency activated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function deactivate(Request $request, $slug = null){
        if($slug != ''){
            Currency::Where('slug',$slug)->update(['status' => 1]);
            return response()->json(['message' => 'Currency deactivated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function delete(Request $request, $slug = null){
        if($slug != ''){
            Currency::Where('slug',$slug)->delete();
            return response()->json(['message' => 'Currency deleted sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }
}
