<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Validator;

use App\Models\Category;

class CategoriesController extends Controller
{
    public function add(Request $request){

        $userDetails = $this->userDetails($request);

        if($userDetails[0] == 'user'){
            if($userDetails[1]->user_type == 'Staff'){
                $user_id = $userDetails[1]->reporting_id;
            }else{
                $user_id = $userDetails[1]->id;
            }
        }else{
            $user_id = $request->user_id;
        }

        $validatedData = Validator($request->all(),[
            'name' => [
                'required',
                Rule::unique('categories')->where(function ($query) use ($user_id){
                    return $query->where('parent_id',0)->where('user_id',$user_id);

                }),
            ],
            'image' => 'required|file|max:2048|mimes:jpeg,jpg,png,gif',
        ]);

        if($validatedData->fails()){
            $msg = $this->validatersErrorString($validatedData->errors());

            return response()->json(['message' => $msg , 'status'=>500],200);
        }

        $customPath = UPLOAD_FULL_CATAGORY_IMAGE_PATH;
        $fileName = bin2hex(openssl_random_pseudo_bytes(4)).'_.'. $request->file('image')->getClientOriginalExtension();
        $filePath = $request->file('image')->move($customPath , $fileName);

        $slug = $this->createSlug('categories',$request->name);

        Category::insert([
            'user_id' => $user_id,
            'name' => $request->name,
            'image' => $fileName,
            'slug' => $slug,
            'status' => 1,
            'parent_id' => 0,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        return response()->json(['message' => 'Category created sucessfully' , 'status'=>200],200);
    }

    public function edit(Request $request, $slug = null){
        if($slug == ''){
            return response()->json(['message' => 'invalid request slug was blank' , 'status'=>500 ],200);
        }

        if(!empty($request->all())){

            $userDetails = $this->userDetails($request);

            if($userDetails[0] == 'user'){
                if($userDetails[1]->user_type == 'Staff'){
                    $user_id = $userDetails[1]->reporting_to;
                }else{
                    $user_id = $userDetails[1]->id;
                }
            }else{
                $user_id = $request->user_id;
            }

            $validatedData = Validator($request->all(),[
                'name' => [
                    'required',
                    Rule::unique('categories')->where(function ($query) use ($slug,$user_id) {
                        return $query->where('slug', '<>', $slug)->where('parent_id',0)->where('user_id',$user_id);
                    }),
                ],
                'image' => 'nullable|file|max:2048|mimes:jpeg,jpg,png,gif',
            ]);

            if($validatedData->fails()){
                $msg = $this->validatersErrorString($validatedData->errors());

                return response()->json(['message' => $msg , 'status'=>500],200);
            }

            if ($request->hasFile('image') && $request->file('image')->getClientOriginalExtension() != '') {
                $customPath = UPLOAD_FULL_CATAGORY_IMAGE_PATH;
                $fileName = bin2hex(openssl_random_pseudo_bytes(4)).'_.'. $request->file('image')->getClientOriginalExtension();
                $filePath = $request->file('image')->move($customPath , $fileName);
            }else{
                $brand = Category::where('slug',$slug)->first();
                $fileName = $brand->image;
            }

            Category::where('slug', $slug)->update([
                'name' => $request->name,
                'image' => $fileName,
            ]);

            return response()->json(['message' => 'Category updated sucessfully' , 'status'=>200],200);
        }else{
            $Category = Category::where('slug',$slug)->first();

            $category_data = array();
            $category_data['name'] = $Category->name;

            if(file_exists(UPLOAD_FULL_CATAGORY_IMAGE_PATH.$Category->image) && $Category->image != ""){
                $category_data['uploaded_category_name'] = DISPLAY_FULL_CATAGORY_IMAGE_PATH.$Category->image;
            }else{
                $category_data['uploaded_category_name'] = "";
            }

            return response()->json(['message' => 'Category data', 'data' => $category_data, 'status'=>200],200);
        }
    }

    public function activate(Request $request, $slug = null){
        if($slug != ''){
            Category::Where('slug',$slug)->update(['status' => 1]);
            return response()->json(['message' => 'Category activated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function deactivate(Request $request, $slug = null){
        if($slug != ''){
            Category::Where('slug',$slug)->update(['status' => 0]);
            return response()->json(['message' => 'Category deactivated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function delete(Request $request, $slug = null){
        if($slug != ''){
            Category::Where('slug',$slug)->delete();
            return response()->json(['message' => 'Category delete sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function index(Request $request){
        $query = Category::where('parent_id',0);

        $userDetails = $this->userDetails($request);

        if($userDetails[0] == 'user'){
            if($userDetails[1]->user_type == 'Staff'){
                $query = $query->where('user_id',$userDetails[1]->reporting_id);
            }else{
                $query = $query->where('user_id',$userDetails[1]->id);
            }
        }

        if(!empty($request->all())){
            $action = $request->action;
            $id = $request->idList;
            if($action != ''){
                if($action ==  'activate'){
                    Category::WhereIn('id',$id)->update(['status' => 1]);
                }else if($action == 'deactivate'){
                    Category::WhereIn('id',$id)->update(['status' => 0]);
                }else if($action == 'delete'){
                    Category::WhereIn('id',$id)->delete();
                }
            }else{
                // if($request->name != ''){
                //     $query = $query->where('name' , 'like' , '%'.$request->name.'%');
                // }
            }
        }

        $Category = $query->get();

        return response()->json(['message' => 'Category data', 'data' => $Category ,'status'=>200],200);
    }

    public function addSubCategory(Request $request , $cslug = null){
        if($cslug == ''){
            return response()->json(['message' => 'invalid request slug was blank' , 'status'=>500 ],200);
        }

        $category = Category::where('slug',$cslug)->first();

        if(!empty($request->all())){

            $userDetails = $this->userDetails($request);

            if($userDetails[0] == 'user'){

                if($userDetails[1]->user_type == 'Staff'){
                    $user_id = $userDetails[1]->reporting_id;
                }else{
                    $user_id = $userDetails[1]->id;
                }
            }else{
                $user_id = $request->user_id;
            }

            $validatedData = Validator($request->all(),[
                'name' => [
                    'required',
                    Rule::unique('categories')->where(function ($query) use ($user_id) {
                        return $query->where('parent_id','<>',0)->where('user_id', $user_id);
                    }),
                ],
            ]);

            if($validatedData->fails()){
                $msg = $this->validatersErrorString($validatedData->errors());

                return response()->json(['message' => $msg , 'status'=>500],200);
            }


            $slug = $this->createSlug('categories',$request->name);

            Category::insert([
                'user_id' => $user_id,
                'name' => $request->name,
                'image' => '',
                'parent_id' => $category->id,
                'slug' => $slug,
                'status' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            return response()->json(['message' => 'Sub Category created sucessfully' , 'status'=>200],200);
        }else{
            return response()->json(['message' => 'Category data' , 'data' => $category  ,'status'=>200],200);
        }
    }

    public function editSubCategory(Request $request , $cslug = null , $slug = null){
        if($slug == '' || $cslug == '' ){
            return response()->json(['message' => 'invalid request slug was blank' , 'status'=>500 ],200);
        }

        if(!empty($request->all())){

            $userDetails = $this->userDetails($request);

            if($userDetails[0] == 'user'){
                // if($userDetails[1]->user_type != 'Biller'){
                //     $user_id = $userDetails[1]->reporting_to;
                // }else{
                    $user_id = $userDetails[1]->id;
                // }
            }else{
                $user_id = $request->user_id;
            }

            $validatedData = Validator($request->all(),[
                'name' => [
                    'required',
                    Rule::unique('categories')->where(function ($query) use ($slug,$user_id) {
                        return $query->where('slug', '<>', $slug)->where('parent_id','<>',0)->where('user_id', $user_id);
                    }),
                ],
            ]);

            if($validatedData->fails()){
                $msg = $this->validatersErrorString($validatedData->errors());

                return response()->json(['message' => $msg , 'status'=>500],200);
            }

            Category::where('slug', $slug)->update([
                'name' => $request->name,
            ]);

            return response()->json(['message' => 'Sub Category updated sucessfully' , 'status'=>200],200);

        }else{
            $subCategory = Category::where('slug', $slug)->first();
            $Category = Category::where('slug', $cslug)->first();

            $data['category'] = $Category;
            $data['subcategory'] = $subCategory;

            return response()->json(['message' => 'Sub Category data', 'data' => $data, 'status'=>200],200);
        }
    }

    public function activateSubCategory(Request $request, $slug = null){
        if($slug != ''){
            Category::Where('slug',$slug)->update(['status' => 1]);
            return response()->json(['message' => 'Sub Category activated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function deactivateSubCategory(Request $request, $slug = null){
        if($slug != ''){
            Category::Where('slug',$slug)->update(['status' => 0]);
            return response()->json(['message' => 'Sub Category deactivated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function deleteSubCategory(Request $request, $slug = null){
        if($slug != ''){
            Category::Where('slug',$slug)->delete();
            return response()->json(['message' => 'Sub Category delete sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function indexSubCategory(Request $request , $cslug = null){
        if($cslug == ''){
            return response()->json(['message' => 'invalid request slug was blank' , 'status'=>500 ],200);
        }

        $Category = Category::where('slug',$cslug)->where('parent_id',0)->first();

        $query = Category::where('parent_id',$Category->id);

        $userDetails = $this->userDetails($request);

        if($userDetails[0] == 'user'){
            if($userDetails[1]->user_type == 'Staff'){
                $query = $query->where('user_id',$userDetails[1]->reporting_id);
            }else{
                $query = $query->where('user_id',$userDetails[1]->id);
            }
        }

        if(!empty($request->all())){
            $action = $request->action;
            $id = $request->idList;
            if($action != ''){
                if($action ==  'activate'){
                    Category::WhereIn('id',$id)->update(['status' => 1]);
                }else if($action == 'deactivate'){
                    Category::WhereIn('id',$id)->update(['status' => 0]);
                }else if($action == 'delete'){
                    Category::WhereIn('id',$id)->delete();
                }
            }else{
                // if($request->name != ''){
                //     $query = $query->where('name' , 'like' , '%'.$request->name.'%');
                // }
            }
        }

        $data['category'] = $Category;
        $data['subcategory'] = $subCategory = $query->get();

        return response()->json(['message' => 'Sub Category data', 'data' => $data ,'status'=>200],200);
    }

    public function getSubCategory(Request $request, $slug = null){
        if($slug == ''){
            return response()->json(['message' => 'invalid request slug was blank' , 'status'=>500 ],200);
        }

        $subCategory = Category::where('parent_id',$slug)->where('status',1)->get();

        return response()->json(['message' => 'sub category data' , 'data' => $subCategory  ,'status'=>200 ],200);
    }

    public function checkCategory(Request $request){

        $userDetails = $this->userDetails($request);

        $user_id = 0;

        if($userDetails[0] == 'user'){
            if($userDetails[1]->user_type == 'Staff'){
                $user_id = $userDetails[1]->reporting_id;
            }else{
                $user_id = $userDetails[1]->id;
            }
        }

        $count = Category::where('category_name' , 'like' , '%'.$request->category_name.'%')->where('user_id',$user_id)->where('parent_id',0)->count();

        if($count > 0){
            return response()->json(['message' => 'Category name already exists','status'=>500],200);
        }else{

            $fileName = '';

            if($request->hasFile('image') && $request->file('image')->getClientOriginalExtension() != ''){

                $customPath = UPLOAD_FULL_CATAGORY_IMAGE_PATH;
                $fileName = bin2hex(openssl_random_pseudo_bytes(4)).'.'. $request->file('image')->getClientOriginalExtension();
                $filePath = $request->file('image')->move($customPath , $fileName);

            }

            $slug = $this->createSlug('categories',$request->name);

            Category::insert([
                'user_id' => $user_id,
                'name' => $request->category_name,
                'image' => $fileName,
                'slug' => $slug,
                'status' => 1,
                'parent_id' => 0,
                'created_at' => now(),
                'updated_at' => now(),
            ]);


            $caregories = Category::where('status',1)->where('user_id',$user_id)->where('parent_id',0)->get();

            return response()->json(['message' => 'Category added successfully','data' => $caregories ,'status'=>200],200);

        }
    }

    public function checkSubCategory(Request $request, $parent = null){
        $userDetails = $this->userDetails($request);

        $user_id = 0;

        if($userDetails[0] == 'user'){
            if($userDetails[1]->user_type == 'Staff'){
                $user_id = $userDetails[1]->reporting_id;
            }else{
                $user_id = $userDetails[1]->id;
            }
        }

        $count = Category::where('category_name' , 'like' , '%'.$request->category_name.'%')->where('user_id',$user_id)->where('parent_id',$parent)->count();

        if($count > 0){
            return response()->json(['message' => 'Sub category name already exists','status'=>500],200);
        }else{
            $slug = $this->createSlug('categories',$request->name);

            Category::insert([
                'user_id' => $user_id,
                'name' => $request->category_name,
                'slug' => $slug,
                'status' => 1,
                'parent_id' => $parent,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            $subCategories = Category::where('category_name' , 'like' , '%'.$request->category_name.'%')->where('user_id',$user_id)->where('parent_id',$parent)->get();

            return response()->json(['message' => 'Sub category added successfully','data' => $subCategories ,'status'=>200],200);

        }
    }

}
