<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

use App\Models\User;
use App\Models\Country;
use Illuminate\Validation\Rule;

class BillersController extends Controller
{
    public function index(Request $request){
        $this->validateApiKey();
        $query = User::where('user_type', 'Biller');

        if(!empty($request->all())){
            $action = $request->action;
            $id = $request->idList;
            if($action != ''){
                if($action ==  'activate'){
                    User::WhereIn('id',$id)->update(['status' => 1]);
                }else if($action == 'deactivate'){
                    User::WhereIn('id',$id)->update(['status' => 0]);
                }else if($action == 'delete'){
                    User::WhereIn('id',$id)->delete();
                }
            }else{
                if($request->name != ''){
                    $query = $query->where('first_name' , 'like' , '%'.$request->name.'%');
                    $query = $query->whereOR('last_name' , 'like' , '%'.$request->name.'%');
                }
            }

            // return response()->json(['message' => 'Biller data', 'data' => $Staffs ,'status'=>200],200);

        }

        $Staffs = $query->get();

        $staffData = array();

        foreach($Staffs as $key =>$staff){

            $staffData[$key]['profile_image'] = '';

            if(file_exists(UPLOAD_FULL_PROFILE_IMAGE_PATH.$staff->profile_image)){
                $staffData[$key]['profile_image'] = DISPLAY_FULL_PROFILE_IMAGE_PATH.$staff->profile_image;
            }

            $staffData[$key]['full_name'] = $staff->full_name;
            $staffData[$key]['company_name'] = $staff->company_name;
            $staffData[$key]['email'] = $staff->email;
            $staffData[$key]['tax'] = $staff->tax;
            $staffData[$key]['tax_percentage'] = $staff->tax_percentage;
            $staffData[$key]['country'] = $staff->country;
            $staffData[$key]['state'] = $staff->state;
            $staffData[$key]['city'] = $staff->city;
            $staffData[$key]['address'] = $staff->address;
            $staffData[$key]['phone'] = $staff->phone;
            $staffData[$key]['created_at'] = $staff->created_at;
            $staffData[$key]['slug'] = $staff->slug;
            $staffData[$key]['id'] = $staff->id;
            $staffData[$key]['status'] = $staff->status;

        }

        return response()->json(['message' => 'Biller data', 'data' => $staffData ,'status'=>200],200);

    }

    public function add(Request $request){
        $this->validateApiKey();

        if(!empty($request->all())){

            $validatedData = Validator($request->all(),[
                'full_name' => 'required',
                'company_name' => 'required',
                'email' => 'required|email|unique:users',
                'password' => 'required',
                're_password' => 'required|same:password',
                'profile_doc' => 'required|max:2048|file|mimes:jpeg,jpg,png,pdf',
                'profile_image' => 'file|max:2048|mimes:jpeg,jpg,png,gif',
                'phone' => 'required',
                'tax' => 'required',
                'tax_percentage' => 'required',
                'company_logo' => 'file|max:2048|mimes:jpeg,jpg,png,gif',
                'country' => 'required',
                'state' => 'required',
                'city' => 'required',
                'address' => 'required'
            ]);


            if($validatedData->fails()){
                $msg = $this->validatersErrorString($validatedData->errors());

                return response()->json(['message' => $msg , 'status'=>500],200);
            }

            $slug = $this->createSlug('users',$request->full_name);

            $customPath = UPLOAD_FULL_PROFILE_IMAGE_PATH;
            $profileFileName = bin2hex(openssl_random_pseudo_bytes(4)).'_.'. $request->file('profile_image')->getClientOriginalExtension();
            $filePath = $request->file('profile_image')->move($customPath , $profileFileName);

            $companyFileName = bin2hex(openssl_random_pseudo_bytes(4)).'_.'. $request->file('company_logo')->getClientOriginalExtension();
            $filePath = $request->file('company_logo')->move($customPath , $companyFileName);

            $customPath = UPLOAD_DOCUMENT_PATH;
            $documentFileName = bin2hex(openssl_random_pseudo_bytes(4)).'_.'. $request->file('profile_doc')->getClientOriginalExtension();
            $filePath = $request->file('profile_doc')->move($customPath , $documentFileName);

            $staffId = User::insertGetId([
                'full_name' => $request->full_name,
                'company_name' => $request->company_name,
                'email' => $request->email,
                'password' => Hash::make($request->password),
                'profile_doc' => $documentFileName,
                'status' => 1,
                'activated' => 1,
                'profile_image' => $profileFileName,
                'user_type' => 'Biller',
                'slug' => $slug,
                'phone' => $request->phone,
                'tax' => $request->tax,
                'tax_percentage' => $request->tax_percentage,
                'country' => $request->country,
                'state' => $request->state,
                'city' => $request->city,
                'address' => $request->address,
                'company_logo' => $companyFileName,
            ]);

            $usercode = 'BILLER0000'.$staffId;

            User::where('id' , $staffId)->update([
                'user_code' => $usercode,
            ]);

            return response()->json(['message' => 'Biller created sucessfully' , 'status'=>200],200);

        }else{
            $country = Country::where('status',1)->get();
            return response()->json(['message' => 'Biller Data' , 'data' => $country , 'status'=>200],200);
        }

    }

    public function edit(Request $request, $slug = null){
        if($slug == ''){
            return response()->json(['message' => 'invalid request slug was blank' , 'status'=>500 ],200);
        }

        if(!empty($request->all())){

            $validatedData = Validator($request->all(),[
                'full_name' => 'required',
                'company_name' => 'required',
                'email' => [
                    'required',
                    'email',
                    Rule::unique('users')->where(function ($query) use ($slug) {
                    $query->where('slug', '<>', $slug);
                }),],
                'password' => 'sometimes|nullable',
                're_password' => 'required_with:password|same:password',
                // 'profile_doc' => 'file|max:2048|file|mimes:jpeg,jpg,png,pdf',
                // 'profile_image' => 'file|max:2048|mimes:jpeg,jpg,png,gif',
                'phone' => 'required',
                'tax' => 'required',
                'tax_percentage' => 'required',
                // 'company_logo' => 'file|max:2048|mimes:jpeg,jpg,png,gif',
                'country' => 'required',
                'state' => 'required',
                'city' => 'required',
                'address' => 'required'
            ]);

            if($validatedData->fails()){
                $msg = $this->validatersErrorString($validatedData->errors());

                return response()->json(['message' => $msg , 'status'=>500],200);
            }

            $user = User::where('slug',$slug)->first();

            if ($request->hasFile('profile_image') && $request->file('profile_image')->getClientOriginalExtension() != '') {
                $customPath = UPLOAD_FULL_PROFILE_IMAGE_PATH;
                $profileFileName = bin2hex(openssl_random_pseudo_bytes(4)).'_.'. $request->file('profile_image')->getClientOriginalExtension();
                $filePath = $request->file('profile_image')->move($customPath , $profileFileName);
            }else{
                $profileFileName = $user->profile_image;
            }

            if ($request->hasFile('company_logo') && $request->file('company_logo')->getClientOriginalExtension() != '') {
                $customPath = UPLOAD_FULL_PROFILE_IMAGE_PATH;
                $companyFileName = bin2hex(openssl_random_pseudo_bytes(4)).'_.'. $request->file('company_logo')->getClientOriginalExtension();
                $filePath = $request->file('company_logo')->move($customPath , $companyFileName);
            }else{
                $companyFileName = $user->company_logo;
            }

            if ($request->hasFile('profile_doc') && $request->file('profile_doc')->getClientOriginalExtension() != '') {
                $customPath = UPLOAD_DOCUMENT_PATH;
                $documentFileName = bin2hex(openssl_random_pseudo_bytes(4)).'_.'. $request->file('profile_doc')->getClientOriginalExtension();
                $filePath = $request->file('profile_doc')->move($customPath , $documentFileName);
            }else{
                $documentFileName = $user->company_logo;
            }

            User::where('slug',$slug)->update([
                'full_name' => $request->full_name,
                'company_name' => $request->company_name,
                'email' => $request->email,
                'profile_doc' => $documentFileName,
                'profile_image' => $profileFileName,
                'phone' => $request->phone,
                'tax' => $request->tax,
                'tax_percentage' => $request->tax_percentage,
                'country' => $request->country,
                'state' => $request->state,
                'city' => $request->city,
                'address' => $request->address,
                'company_logo' => $companyFileName,
            ]);

            if($request->password != ''){
                User::where('slug',$slug)->update([
                    'password' => Hash::make($request->password)
                ]);
            }

            return response()->json(['message' => 'Biller updated sucessfully' , 'status'=>200],200);
        }else{
            $Biller = User::where('slug',$slug)->first();

            $biller_data = array();

            $biller_data['full_name'] = $Biller->full_name;
            $biller_data['company_name'] = $Biller->company_name;
            $biller_data['email'] = $Biller->email;
            $biller_data['phone'] = $Biller->phone;
            $biller_data['tax'] = $Biller->tax;
            $biller_data['tax_percentage'] = $Biller->tax_percentage;
            $biller_data['country'] = $Biller->country;
            $biller_data['state'] = $Biller->state;
            $biller_data['city'] = $Biller->city;
            $biller_data['address'] = $Biller->address;

            if(file_exists(UPLOAD_FULL_PROFILE_IMAGE_PATH.$Biller->profile_image) && $Biller->profile_image != ""){
                $biller_data['uploaded_profile_image'] = DISPLAY_FULL_PROFILE_IMAGE_PATH.$Biller->profile_image;
            }

            $biller_data['profile_doc'] = $Biller->profile_doc;

            if(file_exists(UPLOAD_FULL_PROFILE_IMAGE_PATH.$Biller->company_logo) && $Biller->company_logo != ""){
                $biller_data['uploaded_company_logo'] = DISPLAY_FULL_PROFILE_IMAGE_PATH.$Biller->company_logo;
            }

            $country = Country::where('status',1)->get();

            $data['biller'] = $biller_data;
            $data['country'] = $country;

            return response()->json(['message' => 'Biller data sucessfully' , 'data' => $data ,'status'=>200],200);

        }
    }

    public function activate(Request $request, $slug = null){

        if($slug != ''){
            User::Where('slug',$slug)->update(['status' => 1]);
            return response()->json(['message' => 'Biller activated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function deactivate(Request $request, $slug = null){

        if($slug != ''){
            User::Where('slug',$slug)->update(['status' => 0]);
            return response()->json(['message' => 'Biller deactivated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function delete(Request $request, $slug = null){
        if($slug != ''){
            User::Where('slug',$slug)->delete();
            return response()->json(['message' => 'Biller deleted sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function DeleteImages($slug = null){
        if($slug != ""){
            $user = User::where('slug',$slug)->first();

            User::where('slug',$slug)->update([
                'profile_image' => '',
            ]);

            @unlink(UPLOAD_FULL_PROFILE_IMAGE_PATH.$user->profile_image);

            return response()->json(['message' => 'profile image Deleted successfully' , 'status' => 200 ],200);
        }
    }

    public function addStaff(Request $request, $slug = null){

        if(!empty($request->all())){
            $validatedData = Validator($request->all(),[
                'full_name' => 'required',
                // 'company_name' => 'required',
                'email' => 'required|email|unique:users',
                'password' => 'required',
                're_password' => 'required|same:password',
                // 'profile_doc' => 'required|max:2048|file|mimes:jpeg,jpg,png,pdf',
                'profile_image' => 'file|max:2048|mimes:jpeg,jpg,png,gif',
                'phone' => 'required',
                // 'tax' => 'required',
                // 'tax_percentage' => 'required',
                // 'company_logo' => 'file|max:2048|mimes:jpeg,jpg,png,gif',
                'country' => 'required',
                'state' => 'required',
                'city' => 'required',
                'address' => 'required'
            ]);


            if($validatedData->fails()){
                $msg = $this->validatersErrorString($validatedData->errors());

                return response()->json(['message' => $msg , 'status'=>500],200);
            }


            $userDetails = $this->userDetails($request);

            $reporting_to = 0;

            if($userDetails[0] == 'user'){
                if($userDetails[1]->user_type == 'Staff'){
                    $reporting_to = $userDetails[1]->reporting_id;
                }else{
                    $reporting_to = $userDetails[1]->id;
                }
            }

            $user = User::where('id',$reporting_to)->first();

            $slug = $this->createSlug('users',$request->full_name);

            $customPath = UPLOAD_FULL_PROFILE_IMAGE_PATH;
            $profileFileName = bin2hex(openssl_random_pseudo_bytes(4)).'_.'. $request->file('profile_image')->getClientOriginalExtension();
            $filePath = $request->file('profile_image')->move($customPath , $profileFileName);


            $staffId = User::insertGetId([
                'full_name' => $request->full_name,
                'company_name' => $request->company_name,
                'email' => $request->email,
                'password' => Hash::make($request->password),
                'profile_doc' => '',
                'status' => 1,
                'activated' => 1,
                'profile_image' => $profileFileName,
                'user_type' => 'Staff',
                'slug' => $slug,
                'phone' => $request->phone,
                'tax' => '',
                // 'tax_percentage' => '',
                'country' => $request->country,
                'state' => $request->state,
                'city' => $request->city,
                'address' => $request->address,
                'company_logo' => '',
                'reporting_id' => $reporting_to,
                'currency' => $user->currency,
            ]);

            $usercode = 'STAFF0000'.$staffId;

            User::where('id' , $staffId)->update([
                'user_code' => $usercode,
            ]);


            return response()->json(['message' => 'Staff created sucessfully' , 'status'=>200],200);

        }else{
            $country = Country::where('status',1)->get();
            return response()->json(['message' => 'Biller Data' , 'data' => $country , 'status'=>200],200);
        }

    }

    public function staffIndex(Request $request){

        $query = User::where('user_type', 'Staff');

        $userDetails = $this->userDetails($request);

        if($userDetails[0] == 'user'){

            if($userDetails[1]->user_type == 'Staff'){
                $query =  $query->where('reporting_id',$userDetails[1]->reporting_id);
            }else{
                $query =  $query->where('reporting_id',$userDetails[1]->id);
            }
        }

        if(!empty($request->all())){

            $id = $request->idList;
            $action = $request->action;
            if($action != ''){
                if($action ==  'activate'){
                    User::WhereIn('id',$id)->update(['status' => 1]);
                }else if($action == 'deactivate'){
                    User::WhereIn('id',$id)->update(['status' => 0]);
                }else if($action == 'delete'){
                    User::WhereIn('id',$id)->delete();
                }
            }else{
                if($request->name != ''){
                    $query = $query->where('name' , 'like' , '%'.$request->name.'%');
                }
            }

        }

        $Staffs = $query->get();

        $staffData = array();

        foreach($Staffs as $key =>$staff){

            $staffData[$key]['profile_image'] = '';

            if(file_exists(UPLOAD_FULL_PROFILE_IMAGE_PATH.$staff->profile_image)){
                $staffData[$key]['profile_image'] = DISPLAY_FULL_PROFILE_IMAGE_PATH.$staff->profile_image;
            }

            $staffData[$key]['full_name'] = $staff->full_name;
            $staffData[$key]['email'] = $staff->email;
            $staffData[$key]['country'] = $staff->country;
            $staffData[$key]['state'] = $staff->state;
            $staffData[$key]['city'] = $staff->city;
            $staffData[$key]['address'] = $staff->address;
            $staffData[$key]['phone'] = $staff->phone;
            $staffData[$key]['created_at'] = $staff->created_at;
            $staffData[$key]['slug'] = $staff->slug;
            $staffData[$key]['id'] = $staff->id;
            $staffData[$key]['status'] = $staff->status;

        }

        return response()->json(['message' => 'Staff data', 'data' => $staffData ,'status'=>200],200);
    }

    public function activateStaff(Request $request, $slug = null){

        if($slug != ''){
            User::Where('slug',$slug)->update(['status' => 1]);
            return response()->json(['message' => 'Staff activated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function deactivateStaff(Request $request, $slug = null){

        if($slug != ''){
            User::Where('slug',$slug)->update(['status' => 0]);
            return response()->json(['message' => 'Staff deactivated sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function deleteStaff(Request $request, $slug = null){
        if($slug != ''){
            User::Where('slug',$slug)->delete();
            return response()->json(['message' => 'Staff deleted sucessfully','status'=>200 ],200);
        }
        return response()->json(['message' => 'invalid request slug was blank','status'=>500],200);
    }

    public function editStaff(Request $request, $slug = null){
        if(!empty($request->all())){
            $validatedData = Validator($request->all(),[
                'full_name' => 'required',
                // 'company_name' => 'required',
                'email' => [
                    'required',
                    'email',
                    Rule::unique('users')->where(function ($query) use ($slug) {
                    $query->where('slug', '<>', $slug);
                }),],
                'password' => 'sometimes|nullable',
                're_password' => 'required_with:password|same:password',
                // 'profile_doc' => 'file|max:2048|file|mimes:jpeg,jpg,png,pdf',
                // 'profile_image' => 'file|max:2048|mimes:jpeg,jpg,png,gif',
                'phone' => 'required',
                // 'tax' => 'required',
                // 'tax_percentage' => 'required',
                // 'company_logo' => 'file|max:2048|mimes:jpeg,jpg,png,gif',
                'country' => 'required',
                'state' => 'required',
                'city' => 'required',
                'address' => 'required'
            ]);

            if($validatedData->fails()){
                $msg = $this->validatersErrorString($validatedData->errors());

                return response()->json(['message' => $msg , 'status'=>500],200);
            }

            $user = User::where('slug',$slug)->first();

            if ($request->hasFile('profile_image') && $request->file('profile_image')->getClientOriginalExtension()!= '') {
                $customPath = UPLOAD_FULL_PROFILE_IMAGE_PATH;
                $profileFileName = bin2hex(openssl_random_pseudo_bytes(4)).'_.'. $request->file('profile_image')->getClientOriginalExtension();
                $filePath = $request->file('profile_image')->move($customPath , $profileFileName);
            }else{
                $profileFileName = $user->profile_image;
            }

            User::where('slug',$slug)->update([

                'full_name' => $request->full_name,
                'email' => $request->email,
                'profile_image' => $profileFileName,
                'phone' => $request->phone,
                'country' => $request->country,
                'state' => $request->state,
                'city' => $request->city,
                'address' => $request->address,
            ]);

            if($request->password != ''){
                User::where('slug',$slug)->update([
                    'password' => Hash::make($request->password)
                ]);
            }

            return response()->json(['message' => 'Staff updated sucessfully' , 'status'=>200],200);


        }else{
            $Biller = User::where('slug',$slug)->first();

            $biller_data = array();

            $biller_data['full_name'] = $Biller->full_name;
            $biller_data['company_name'] = $Biller->company_name;
            $biller_data['email'] = $Biller->email;
            $biller_data['phone'] = $Biller->phone;
            $biller_data['country'] = $Biller->country;
            $biller_data['state'] = $Biller->state;
            $biller_data['city'] = $Biller->city;
            $biller_data['address'] = $Biller->address;

            if(file_exists(UPLOAD_FULL_PROFILE_IMAGE_PATH.$Biller->profile_image) && $Biller->profile_image != ""){
                $biller_data['uploaded_profile_image'] = DISPLAY_FULL_PROFILE_IMAGE_PATH.$Biller->profile_image;
            }

            $country = Country::where('status',1)->get();

            $data['biller'] = $biller_data;
            $data['country'] = $country;

            return response()->json(['message' => 'Staff data' , 'data' => $data ,'status'=>200],200);
        }
    }



}
